/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects;

import com.mojang.serialization.DynamicOps;
import dev.foxgirl.trimeffects.Config;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrimEffects {
    public static final Logger LOGGER = LogManager.getLogger((String)"trimeffects");
    private static TrimEffects INSTANCE;
    private Config.Parsed config;
    private final Map<UUID, Integer> absorptionStunTicks = new HashMap<UUID, Integer>();

    @NotNull
    public static TrimEffects getInstance() {
        return INSTANCE;
    }

    @NotNull
    public static TrimEffects createInstance() {
        return new TrimEffects();
    }

    private TrimEffects() {
        INSTANCE = this;
    }

    @NotNull
    public Config.Parsed getConfig() {
        return Objects.requireNonNull(this.config, "Expression 'config'");
    }

    public void initialize(@NotNull Path configDirectory) {
        this.config = Config.read(configDirectory).parse();
    }

    @NotNull
    public static class_5455 getRegistryManager(@NotNull class_1297 entity) {
        return entity.method_37908().method_30349();
    }

    @NotNull
    public static <T> class_5321<T> getKey(@NotNull class_6880<T> entry) {
        return (class_5321)entry.method_40230().orElseThrow();
    }

    @Nullable
    public static class_8053 getTrim(@NotNull class_5455 manager, @NotNull class_1799 stack) {
        class_2487 nbt = stack.method_7941("Trim");
        if (nbt == null || !stack.method_31573(class_3489.field_41890)) {
            return null;
        }
        return class_8053.field_41994.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)manager), (Object)nbt).result().orElse(null);
    }

    public void handleTick(class_1309 player) {
        class_5455 manager = TrimEffects.getRegistryManager((class_1297)player);
        List armor = (List)player.method_5661();
        Trim[] trims = new Trim[armor.size()];
        int length = trims.length;
        for (int i = 0; i < length; ++i) {
            trims[i] = Trim.from(manager, (class_1799)armor.get(i));
        }
        for (Trim trim : trims) {
            int count;
            if (trim == null || (!this.getConfig().isEnableCombinedEffects() ? Arrays.stream(trims).anyMatch(t -> t != null && !trim.equals(t)) : Arrays.stream(trims).anyMatch(t -> t != null && !trim.equals(t) && trim.getPattern().equals(t.getPattern()))) || (count = (int)Arrays.stream(trims).filter(t -> Objects.equals(t, trim)).count()) < this.getConfig().getMinimumMatchingTrims()) continue;
            this.handleTickForTrim(player, trim);
        }
    }

    private void handleTickForTrim(class_1309 player, Trim trim) {
        class_5455 manager = TrimEffects.getRegistryManager((class_1297)player);
        class_5321<class_8056> pattern = TrimEffects.getKey(trim.getPattern());
        class_5321<class_8054> material = TrimEffects.getKey(trim.getMaterial());
        class_5321<class_1291> effect = this.getConfig().getEffects().get(pattern);
        Integer strength = this.getConfig().getStrengths().get(material);
        int durationMaximum = (int)((this.getConfig().getSecondsMaximum() + 0.75) * 20.0);
        int durationMinimum = (int)((this.getConfig().getSecondsMinimum() + 0.75) * 20.0);
        if (effect != null && strength != null && strength > 0) {
            class_1293 effectInstance;
            int amplifier = strength - 1;
            class_1291 effectType = (class_1291)manager.method_30530(class_7924.field_41208).method_29107(effect);
            if (effectType != null && ((effectInstance = player.method_6112(effectType)) == null || effectInstance.method_5578() < amplifier || effectInstance.method_48557(durationMinimum))) {
                if (effectType == class_1294.field_5898) {
                    Integer stunTicks = this.absorptionStunTicks.get(player.method_5667());
                    if (stunTicks != null && stunTicks > 0) {
                        this.absorptionStunTicks.put(player.method_5667(), stunTicks - 1);
                        return;
                    }
                    if (effectInstance != null && player.method_6067() < player.method_52541()) {
                        this.absorptionStunTicks.put(player.method_5667(), (int)(this.getConfig().getAbsorptionStunSeconds() * 2.0));
                        return;
                    }
                }
                player.method_37222(new class_1293(effectType, durationMaximum, amplifier), (class_1297)player);
            }
        }
    }

    private record Trim(@NotNull class_8053 trim) {
        private static Trim from(@NotNull class_5455 manager, @NotNull class_1799 stack) {
            class_8053 trim = TrimEffects.getTrim(manager, stack);
            return trim == null ? null : new Trim(trim);
        }

        @NotNull
        private class_6880<class_8056> getPattern() {
            return this.trim.method_48424();
        }

        @NotNull
        private class_6880<class_8054> getMaterial() {
            return this.trim.method_48431();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Trim that = (Trim)obj;
            return Objects.equals(this.getPattern(), that.getPattern()) && Objects.equals(this.getMaterial(), that.getMaterial());
        }
    }
}

