/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.util;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.common.BackpackManager;
import com.tiviacz.travelersbackpack.compat.trinkets.TrinketsCompat;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.util.LogHelper;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class BackpackUtils {
    public static boolean onPlayerDrops(class_1937 world, class_1657 player, class_1799 stack) {
        if (!world.field_9236) {
            BackpackManager.addBackpack((class_3222)player, stack);
        }
        if (TravelersBackpack.isAnyGraveModInstalled()) {
            return true;
        }
        boolean drop = true;
        if (TravelersBackpackConfig.getConfig().backpackSettings.backpackDeathPlace) {
            drop = TravelersBackpackConfig.getConfig().backpackSettings.backpackForceDeathPlace ? !BackpackUtils.placeBackpack(world, player, player.method_24515(), stack) : !BackpackUtils.tryPlace(world, player, stack);
        }
        return drop;
    }

    private static boolean placeBackpack(class_1937 world, class_1657 player, class_2338 placePos, class_1799 stack) {
        if (stack.method_7969() == null) {
            stack.method_7980(new class_2487());
        }
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        int y = placePos.method_10264();
        if (TravelersBackpackConfig.getConfig().backpackSettings.backpackForceDeathPlace) {
            class_2338 targetPos;
            class_2338 playerPos = player.method_24515();
            y = playerPos.method_10264();
            if (TravelersBackpackConfig.getConfig().backpackSettings.voidProtection && y <= world.method_31607()) {
                y = world.method_31607() + 5;
            }
            for (int i = y; i < world.method_31605(); ++i) {
                if (!world.method_8320(new class_2338(playerPos.method_10263(), i, playerPos.method_10260())).method_26215()) continue;
                y = i;
                break;
            }
            if (world.method_8320(targetPos = new class_2338(playerPos.method_10263(), y, playerPos.method_10260())).method_26204().method_9520() > -1.0f) {
                while (world.method_8321(targetPos) != null) {
                    targetPos = targetPos.method_10084();
                }
                if (!world.method_8501(targetPos, block.method_9564())) {
                    return false;
                }
                BackpackUtils.placeBackpackInTheWorld(world, player, targetPos, block, stack);
                return true;
            }
            return false;
        }
        if (y <= world.method_31607() || y >= world.method_31605()) {
            return false;
        }
        class_2338 targetPos = new class_2338(placePos.method_10263(), y, placePos.method_10260());
        if (!world.method_8501(targetPos, block.method_9564())) {
            return false;
        }
        BackpackUtils.placeBackpackInTheWorld(world, player, targetPos, block, stack);
        return true;
    }

    private static void placeBackpackInTheWorld(class_1937 world, class_1657 player, class_2338 targetPos, class_2248 block, class_1799 stack) {
        class_2540 data = PacketByteBufs.create();
        data.writeBoolean(false);
        data.method_10807(targetPos);
        ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)ModNetwork.SEND_MESSAGE_ID, (class_2540)data);
        LogHelper.info("Your backpack has been placed at X: " + targetPos.method_10263() + " Y: " + targetPos.method_10264() + " Z: " + targetPos.method_10260(), new Object[0]);
        world.method_43128(player, (double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260(), block.method_9564().method_26231().method_10598(), class_3419.field_15245, 0.5f, 1.0f);
        ((TravelersBackpackBlockEntity)world.method_8321(targetPos)).readAllData(stack.method_7969());
        if (stack.method_7938()) {
            ((TravelersBackpackBlockEntity)world.method_8321(targetPos)).setCustomName(stack.method_7964());
        }
        if (ComponentUtils.isWearingBackpack(player) && !world.field_9236) {
            ComponentUtils.getComponent(player).removeWearable();
        }
        if (TravelersBackpack.enableTrinkets()) {
            TrinketsCompat.rightClickUnequip(player, stack);
        }
    }

    private static boolean tryPlace(class_1937 world, @NotNull class_1657 player, class_1799 stack) {
        int[] positions;
        int X = (int)player.method_23317();
        int Z = (int)player.method_23321();
        for (int Y : positions = new int[]{0, -1, 1, -2, 2, -3, 3, -4, 4, -5, 5, -6, 6}) {
            class_2338 spawn;
            int y = (int)player.method_23318();
            if (TravelersBackpackConfig.getConfig().backpackSettings.voidProtection && y <= world.method_31607()) {
                y = world.method_31607() + 5;
            }
            if ((spawn = BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, X, Z, new class_2338(X, y + Y, Z), 12, true, 1, (byte)0)) == null) continue;
            return BackpackUtils.placeBackpack(world, player, spawn, stack);
        }
        return false;
    }

    public static class_2338 findBlock3D(class_1937 world, int x, int y, int z, class_2248 block, int hRange, int vRange) {
        for (int i = y - vRange; i <= y + vRange; ++i) {
            for (int j = x - hRange; j <= x + hRange; ++j) {
                for (int k = z - hRange; k <= z + hRange; ++k) {
                    if (world.method_8320(new class_2338(j, i, k)).method_26204() != block) continue;
                    return new class_2338(j, i, k);
                }
            }
        }
        return null;
    }

    public static String getConvertedTime(int ticks) {
        int i = ticks / 20;
        int minutes = i / 60;
        int seconds = i % 60;
        if (seconds < 10) {
            return minutes + ":0" + seconds;
        }
        return minutes + ":" + seconds;
    }

    public static boolean isShiftPressed() {
        return GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)340) == 1 || GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)344) == 1;
    }

    public static boolean isCtrlPressed() {
        return GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)341) == 1 || GLFW.glfwGetKey((long)class_310.method_1551().method_22683().method_4490(), (int)345) == 1;
    }

    public static class_2338 getNearestEmptyChunkCoordinatesSpiral(class_1657 player, class_1937 world, int origX, int origZ, class_2338 pos, int radius, boolean except, int steps, byte pass) {
        int j;
        int i;
        if (steps >= radius) {
            return null;
        }
        if (steps % 2 == 0) {
            if (pass == 0) {
                for (i = pos.method_10263(); i <= pos.method_10263() + steps; ++i) {
                    class_2338 blockPos = BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, steps, pass);
            }
            if (pass == 1) {
                for (j = pos.method_10260(); j >= pos.method_10260() - steps; --j) {
                    class_2338 blockPos = BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos == null) continue;
                    return blockPos;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, ++steps, pass);
            }
        }
        if (steps % 2 == 1) {
            if (pass == 0) {
                while (i >= pos.method_10263() - steps) {
                    class_2338 blockPos = BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    --i;
                }
                pass = (byte)(pass + 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, steps, pass);
            }
            if (pass == 1) {
                while (j <= pos.method_10260() + steps) {
                    class_2338 blockPos = BackpackUtils.checkCoordsForBackpack(player, world, origX, origZ, pos, except);
                    if (blockPos != null) {
                        return blockPos;
                    }
                    ++j;
                }
                pass = (byte)(pass - 1);
                return BackpackUtils.getNearestEmptyChunkCoordinatesSpiral(player, world, origX, origZ, new class_2338(i, pos.method_10264(), j), radius, except, ++steps, pass);
            }
        }
        return null;
    }

    private static class_2338 checkCoordsForBackpack(class_1657 player, class_1937 world, int origX, int origZ, class_2338 pos, boolean except) {
        if (except && world.method_8515(pos.method_10093(class_2350.field_11033), (class_1297)player) && (world.method_22347(pos) || world.method_8320(pos).method_45474()) && !BackpackUtils.areCoordinatesTheSame(new class_2338(origX, pos.method_10264(), origZ), pos)) {
            return pos;
        }
        if (!except && world.method_8515(pos.method_10093(class_2350.field_11033), (class_1297)player) && (world.method_22347(pos) || world.method_8320(pos).method_45474())) {
            return pos;
        }
        return null;
    }

    private static boolean areCoordinatesTheSame(class_2338 pos1, class_2338 pos2) {
        return pos1 == pos2;
    }
}

