/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_8060;

public class BackpackUpgradeRecipe
extends class_8060 {
    final class_1856 template;
    final class_1856 base;
    final class_1856 addition;
    final class_1799 result;

    public BackpackUpgradeRecipe(class_2960 id, class_1856 template, class_1856 base, class_1856 addition, class_1799 result) {
        super(id, template, base, addition, result);
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        class_1799 itemstack = this.result.method_7972();
        class_2487 nbtCompound = inventory.method_5438(1).method_7969();
        if (nbtCompound != null) {
            nbtCompound = nbtCompound.method_10553();
            if (inventory.method_5438(2).method_31574(ModItems.CRAFTING_UPGRADE)) {
                if (nbtCompound.method_10545("CraftingSettings")) {
                    if (nbtCompound.method_10547("CraftingSettings")[0] == 0) {
                        byte[] newArray = new byte[]{1, 0, 1};
                        nbtCompound.method_10570("CraftingSettings", newArray);
                        itemstack.method_7980(nbtCompound);
                        return itemstack;
                    }
                } else {
                    byte[] newArray = new byte[]{1, 0, 1};
                    nbtCompound.method_10570("CraftingSettings", newArray);
                    itemstack.method_7980(nbtCompound);
                    return itemstack;
                }
            }
            if (nbtCompound.method_10545("Tier")) {
                Tiers.Tier tier = Tiers.of(nbtCompound.method_10550("Tier"));
                if (inventory.method_5438(2).method_31574(Tiers.of(nbtCompound.method_10550("Tier")).getTierUpgradeIngredient())) {
                    this.upgradeInventory(nbtCompound, tier);
                    itemstack.method_7980(nbtCompound.method_10553());
                    return itemstack;
                }
            } else if (inventory.method_5438(2).method_31574(Tiers.LEATHER.getTierUpgradeIngredient())) {
                this.upgradeInventory(nbtCompound, Tiers.LEATHER);
                itemstack.method_7980(nbtCompound.method_10553());
                return itemstack;
            }
        }
        return class_1799.field_8037;
    }

    public void upgradeInventory(class_2487 compound, Tiers.Tier tier) {
        compound.method_10569("Tier", tier.getNextTier().getOrdinal());
        if (compound.method_10545("ToolsInventory") && compound.method_10562("ToolsInventory").method_10573("Size", 3)) {
            compound.method_10562("ToolsInventory").method_10569("Size", tier.getNextTier().getToolSlots());
        }
        if (compound.method_10545("Inventory") && compound.method_10562("Inventory").method_10573("Size", 3)) {
            compound.method_10562("Inventory").method_10569("Size", tier.getNextTier().getStorageSlots());
        }
        if (compound.method_10545("LeftTank") && compound.method_10562("LeftTank").method_10573("capacity", 4)) {
            compound.method_10562("LeftTank").method_10544("capacity", tier.getNextTier().getTankCapacity());
        }
        if (compound.method_10545("RightTank") && compound.method_10562("RightTank").method_10573("capacity", 4)) {
            compound.method_10562("RightTank").method_10544("capacity", tier.getNextTier().getTankCapacity());
        }
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        class_1799 addition = inventory.method_5438(2);
        boolean flag = true;
        if (!TravelersBackpackConfig.getConfig().backpackSettings.enableCraftingUpgrade) {
            boolean bl = flag = !addition.method_31574(ModItems.CRAFTING_UPGRADE);
        }
        if (!TravelersBackpackConfig.getConfig().backpackSettings.enableTierUpgrades) {
            flag = !addition.method_31574(ModItems.IRON_TIER_UPGRADE) && !addition.method_31574(ModItems.GOLD_TIER_UPGRADE) && !addition.method_31574(ModItems.DIAMOND_TIER_UPGRADE) && !addition.method_31574(ModItems.NETHERITE_TIER_UPGRADE);
        }
        return this.matchesTier(inventory, world) && flag && super.method_8115(inventory, world);
    }

    public boolean matchesTier(class_1263 inventory, class_1937 world) {
        class_1799 base = inventory.method_5438(1);
        class_1799 addition = inventory.method_5438(2);
        if (addition.method_7909() == ModItems.CRAFTING_UPGRADE) {
            return true;
        }
        if (!base.method_7985() || !base.method_7969().method_10545("Tier")) {
            return addition.method_31574(ModItems.IRON_TIER_UPGRADE);
        }
        if (base.method_7969().method_10545("Tier")) {
            int tier = base.method_7969().method_10550("Tier");
            return switch (tier) {
                case 0 -> {
                    if (addition.method_7909() == ModItems.IRON_TIER_UPGRADE) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (addition.method_7909() == ModItems.GOLD_TIER_UPGRADE) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (addition.method_7909() == ModItems.DIAMOND_TIER_UPGRADE) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (addition.method_7909() == ModItems.NETHERITE_TIER_UPGRADE) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.BACKPACK_UPGRADE;
    }

    public static class Serializer
    implements class_1865<BackpackUpgradeRecipe> {
        public BackpackUpgradeRecipe read(class_2960 identifier, JsonObject jsonObject) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)jsonObject, (String)"template"));
            class_1856 ingredient2 = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)jsonObject, (String)"base"));
            class_1856 ingredient3 = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)jsonObject, (String)"addition"));
            class_1799 itemStack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
            return new BackpackUpgradeRecipe(identifier, ingredient, ingredient2, ingredient3, itemStack);
        }

        public BackpackUpgradeRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
            class_1856 ingredient = class_1856.method_8086((class_2540)packetByteBuf);
            class_1856 ingredient2 = class_1856.method_8086((class_2540)packetByteBuf);
            class_1856 ingredient3 = class_1856.method_8086((class_2540)packetByteBuf);
            class_1799 itemStack = packetByteBuf.method_10819();
            return new BackpackUpgradeRecipe(identifier, ingredient, ingredient2, ingredient3, itemStack);
        }

        public void write(class_2540 packetByteBuf, BackpackUpgradeRecipe upgradeRecipe) {
            upgradeRecipe.template.method_8088(packetByteBuf);
            upgradeRecipe.base.method_8088(packetByteBuf);
            upgradeRecipe.addition.method_8088(packetByteBuf);
            packetByteBuf.method_10793(upgradeRecipe.result);
        }
    }
}

