/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5944;

public class RenderStateConfiguration {
    private final List<RenderStateEntry> renderStateEntries;

    public static Builder builder() {
        return new Builder();
    }

    private RenderStateConfiguration(List<RenderStateEntry> renderStateEntries) {
        this.renderStateEntries = renderStateEntries;
    }

    public void setup() {
        this.renderStateEntries.forEach(RenderStateEntry::setup);
    }

    public void clear() {
        this.renderStateEntries.forEach(RenderStateEntry::clear);
    }

    public static class Builder {
        private RenderStateEntry textureState;
        private RenderStateEntry shaderState;
        private RenderStateEntry transparencyState;
        private RenderStateEntry depthTestState;
        private RenderStateEntry cullingState;
        private RenderStateEntry lightmapState;
        private RenderStateEntry overlayState;
        private RenderStateEntry layeringState;
        private RenderStateEntry depthMaskState;
        private RenderStateEntry colorMaskState;
        private RenderStateEntry lineWidthState;
        private final List<RenderStateEntry> entries = new ArrayList<RenderStateEntry>();

        private Builder() {
            this.disableTexture();
            this.disableShader();
            this.disableTransparency();
            this.useLessThanOrEqualDepthTest();
            this.enableCulling();
            this.disableLightmap();
            this.disableOverlay();
            this.disableLayering();
            this.enableDepthMask();
            this.enableColorMask();
            this.useDefaultLineWidth();
        }

        public Builder append(RenderStateEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder disableTexture() {
            this.textureState = new RenderStateEntry(null, null);
            return this;
        }

        public Builder useTexture(class_2960 texture, boolean useBlur, boolean useMipmap) {
            this.textureState = new RenderStateEntry(() -> {
                ClientUtils.getTextureManager().method_4619(texture).method_4527(useBlur, useMipmap);
                RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            }, null);
            return this;
        }

        public Builder disableShader() {
            return this.useShader(() -> null);
        }

        public Builder useShader(Supplier<class_5944> shader) {
            this.shaderState = new RenderStateEntry(() -> RenderSystem.setShader((Supplier)shader), null);
            return this;
        }

        public Builder disableTransparency() {
            this.transparencyState = new RenderStateEntry(RenderSystem::disableBlend, null);
            return this;
        }

        public Builder useAdditiveTransparency() {
            this.transparencyState = new RenderStateEntry(() -> {
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            }, () -> {
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
            });
            return this;
        }

        public Builder useTranslucentTransparency() {
            this.transparencyState = new RenderStateEntry(() -> {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            }, () -> {
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
            });
            return this;
        }

        public Builder disableDepthTest() {
            this.depthTestState = new RenderStateEntry(RenderSystem::disableDepthTest, null);
            return this;
        }

        public Builder useEqualDepthTest() {
            this.depthTestState = new RenderStateEntry(() -> {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)514);
            }, () -> {
                RenderSystem.disableDepthTest();
                RenderSystem.depthFunc((int)515);
            });
            return this;
        }

        public Builder useLessThanOrEqualDepthTest() {
            this.depthTestState = new RenderStateEntry(() -> {
                RenderSystem.enableDepthTest();
                RenderSystem.depthFunc((int)515);
            }, RenderSystem::disableDepthTest);
            return this;
        }

        public Builder disableCulling() {
            this.cullingState = new RenderStateEntry(RenderSystem::disableCull, RenderSystem::enableCull);
            return this;
        }

        public Builder enableCulling() {
            this.cullingState = new RenderStateEntry(RenderSystem::enableCull, null);
            return this;
        }

        public Builder disableLightmap() {
            this.lightmapState = new RenderStateEntry(() -> ClientUtils.getMinecraft().field_1773.method_22974().method_3315(), null);
            return this;
        }

        public Builder enableLightmap() {
            this.lightmapState = new RenderStateEntry(() -> ClientUtils.getMinecraft().field_1773.method_22974().method_3316(), () -> ClientUtils.getMinecraft().field_1773.method_22974().method_3315());
            return this;
        }

        public Builder disableOverlay() {
            this.overlayState = new RenderStateEntry(() -> ClientUtils.getMinecraft().field_1773.method_22975().method_23213(), null);
            return this;
        }

        public Builder enableOverlay() {
            this.overlayState = new RenderStateEntry(() -> ClientUtils.getMinecraft().field_1773.method_22975().method_23209(), () -> ClientUtils.getMinecraft().field_1773.method_22975().method_23213());
            return this;
        }

        public Builder disableLayering() {
            this.layeringState = new RenderStateEntry(RenderSystem::disablePolygonOffset, null);
            return this;
        }

        public Builder usePolygonOffsetLayering() {
            this.layeringState = new RenderStateEntry(() -> {
                RenderSystem.polygonOffset((float)-1.0f, (float)-10.0f);
                RenderSystem.enablePolygonOffset();
            }, () -> {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            });
            return this;
        }

        public Builder useViewOffsetZLayering() {
            this.layeringState = new RenderStateEntry(() -> {
                class_4587 posestack = RenderSystem.getModelViewStack();
                posestack.method_22903();
                posestack.method_22905(0.99975586f, 0.99975586f, 0.99975586f);
                RenderSystem.applyModelViewMatrix();
            }, () -> {
                class_4587 posestack = RenderSystem.getModelViewStack();
                posestack.method_22909();
                RenderSystem.applyModelViewMatrix();
            });
            return this;
        }

        public Builder disableDepthMask() {
            this.depthMaskState = new RenderStateEntry(() -> RenderSystem.depthMask((boolean)false), () -> RenderSystem.depthMask((boolean)true));
            return this;
        }

        public Builder enableDepthMask() {
            this.depthMaskState = new RenderStateEntry(() -> RenderSystem.depthMask((boolean)true), null);
            return this;
        }

        public Builder disableColorMask() {
            this.colorMaskState = new RenderStateEntry(() -> RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false), () -> RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true));
            return this;
        }

        public Builder enableColorMask() {
            this.colorMaskState = new RenderStateEntry(() -> RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true), null);
            return this;
        }

        public Builder useColorMask(boolean writeRed, boolean writeGreen, boolean writeBlue, boolean writeAlpha) {
            this.colorMaskState = new RenderStateEntry(() -> RenderSystem.colorMask((boolean)writeRed, (boolean)writeGreen, (boolean)writeBlue, (boolean)writeAlpha), () -> RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true));
            return this;
        }

        public Builder useDefaultLineWidth() {
            this.lineWidthState = new RenderStateEntry(() -> RenderSystem.lineWidth((float)1.0f), null);
            return this;
        }

        public Builder useLineWidth(float width) {
            this.lineWidthState = new RenderStateEntry(() -> RenderSystem.lineWidth((float)width), () -> RenderSystem.lineWidth((float)1.0f));
            return this;
        }

        public Builder useWindowRelativeLineWidth() {
            this.lineWidthState = new RenderStateEntry(() -> RenderSystem.lineWidth((float)Math.max(2.5f, (float)ClientUtils.getMinecraft().method_22683().method_4489() / 1920.0f * 2.5f)), () -> RenderSystem.lineWidth((float)1.0f));
            return this;
        }

        public RenderStateConfiguration build() {
            ArrayList<RenderStateEntry> combinedEntries = new ArrayList<RenderStateEntry>(11 + this.entries.size());
            combinedEntries.add(this.textureState);
            combinedEntries.add(this.shaderState);
            combinedEntries.add(this.transparencyState);
            combinedEntries.add(this.depthTestState);
            combinedEntries.add(this.cullingState);
            combinedEntries.add(this.lightmapState);
            combinedEntries.add(this.overlayState);
            combinedEntries.add(this.layeringState);
            combinedEntries.add(this.depthMaskState);
            combinedEntries.add(this.colorMaskState);
            combinedEntries.add(this.lineWidthState);
            combinedEntries.addAll(this.entries);
            return new RenderStateConfiguration(combinedEntries);
        }
    }

    public static final class RenderStateEntry {
        private final Runnable setup;
        private final Runnable clear;

        public RenderStateEntry(Runnable setup, Runnable clear) {
            this.setup = setup == null ? () -> {} : setup;
            this.clear = clear == null ? () -> {} : clear;
        }

        public void setup() {
            this.setup.run();
        }

        public void clear() {
            this.clear.run();
        }
    }
}

