/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core;

import com.cursee.monolib.Constants;
import com.cursee.monolib.platform.Services;
import com.cursee.monolib.util.toml.Toml;
import com.cursee.monolib.util.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MonoLibConfiguration {
    public static final File CONFIG_DIRECTORY = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config");
    public static final String CONFIG_FILEPATH = CONFIG_DIRECTORY + File.separator + "monolib.toml";
    public static boolean debugging = false;
    public static boolean enableAntiRepostingCheck = true;
    public static final Map<String, Object> defaults = new HashMap<String, Object>();

    public static void initialize() {
        File CONFIG_FILE;
        defaults.put("debugging", false);
        defaults.put("enableAntiRepostingCheck", true);
        if (!CONFIG_DIRECTORY.isDirectory()) {
            CONFIG_DIRECTORY.mkdir();
        }
        if (!(CONFIG_FILE = new File(CONFIG_FILEPATH)).isFile()) {
            try {
                TomlWriter writer = new TomlWriter();
                writer.write(defaults, new File(CONFIG_FILEPATH));
            }
            catch (IOException exception) {
                Constants.LOG.error("Error(s) occurred while attempting to write monolib.toml");
                Constants.LOG.error(exception.getMessage());
                Constants.LOG.error("Have you loaded the mod in the wrong loader?");
                throw new RuntimeException(exception);
            }
        }
        try {
            Toml toml = new Toml().read(CONFIG_FILE);
            debugging = toml.getBoolean("debugging");
            enableAntiRepostingCheck = toml.getBoolean("enableAntiRepostingCheck");
        }
        catch (IllegalStateException exception) {
            Constants.LOG.error("Error(s) occurred while attempting to parse monolib.toml");
            Constants.LOG.error(exception.getMessage());
            Constants.LOG.error("Configuration values set to defaults.");
            Constants.LOG.error("Only TOML specification v0.4.0 is valid. Reference: https://www.toml.io/en/v0.4.0");
        }
    }
}

