/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataObjectReference<T>
implements Supplier<T> {
    private static final WeakHashSet<DataObjectReference<?>> REFERENCES = new WeakHashSet();
    private final class_5321<class_2378<T>> registryKey;
    private final class_5321<T> key;
    @Nullable
    private class_6880<T> cache;

    public DataObjectReference(String id, class_5321<class_2378<T>> registry) {
        this(new class_2960(id), registry);
    }

    public DataObjectReference(class_2960 location, class_5321<class_2378<T>> registry) {
        this.registryKey = registry;
        this.key = class_5321.method_29179(this.registryKey, (class_2960)location);
        REFERENCES.add(this);
    }

    public DataObjectReference(class_5321<T> key) {
        this.key = key;
        this.registryKey = class_5321.method_29180((class_2960)key.method_41185());
        REFERENCES.add(this);
    }

    public class_6880<T> getHolder() {
        if (this.cache == null) {
            class_5455 r = Utils.hackyGetRegistryAccess();
            class_2378 reg = r.method_30530(this.registryKey);
            try {
                this.cache = reg.method_40290(this.key);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get object from registry: " + this.key + ".\nCalled from " + Thread.currentThread() + ".\nRegistry content was: " + reg.method_29722().stream().map(Map.Entry::getValue).toList(), e);
            }
        }
        return this.cache;
    }

    @Override
    @NotNull
    public T get() {
        return (T)this.getHolder().comp_349();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public T getUnchecked() {
        return this.get();
    }

    public void clearCache() {
        this.cache = null;
    }

    public class_2960 getID() {
        return this.key.method_29177();
    }

    @ApiStatus.Internal
    public static void onDataReload() {
        REFERENCES.forEach(DataObjectReference::clearCache);
    }
}

