/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.entity;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2643;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3857;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImprovedProjectileEntity
extends class_3857 {
    protected boolean isInBlock = false;
    protected int inBlockTime = 0;
    protected int maxAge = 300;
    protected int maxInBlockTime = 20;
    @Deprecated(forRemoval=true)
    public boolean touchedGround;
    @Deprecated(forRemoval=true)
    public int groundTime = 0;

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, class_1937 world) {
        super(type, world);
        this.method_49477(0.0f);
    }

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, double x, double y, double z, class_1937 world) {
        this(type, world);
        this.method_5814(x, y, z);
    }

    protected ImprovedProjectileEntity(class_1299<? extends class_3857> type, class_1309 thrower, class_1937 world) {
        this(type, thrower.method_23317(), thrower.method_23320() - (double)0.1f, thrower.method_23321(), world);
        this.method_7432((class_1297)thrower);
    }

    public float method_49476() {
        return super.method_49476();
    }

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.5f;
    }

    public boolean collidesWithBlocks() {
        return false;
    }

    public void method_5773() {
        float deceleration;
        class_265 voxelshape;
        if (!this.field_28646) {
            this.method_32875(class_5712.field_28161, this.method_24921());
            this.field_28646 = true;
        }
        this.method_5670();
        this.field_28629 = this.method_5809();
        class_1937 level = this.method_37908();
        class_243 pos = this.method_19538();
        class_2338 blockpos = this.method_24515();
        class_243 movement = this.method_18798();
        boolean client = level.field_9236;
        class_2680 blockstate = level.method_8320(blockpos);
        if (!blockstate.method_26215() && !(voxelshape = blockstate.method_26194((class_1922)level, blockpos, class_3726.method_16195((class_1297)this))).method_1110()) {
            class_243 centerPos = this.method_33571();
            for (class_238 aabb : voxelshape.method_1090()) {
                if (!aabb.method_996(blockpos).method_1006(centerPos)) continue;
                this.isInBlock = true;
                break;
            }
        }
        if (this.method_5721() || blockstate.method_27852(class_2246.field_27879)) {
            this.method_5646();
        }
        if (this.isInBlock && !this.field_5960) {
            ++this.inBlockTime;
            return;
        }
        this.inBlockTime = 0;
        this.method_26962();
        class_3965 hitResult = this.getColliderType() == ColliderType.RAY ? level.method_17742(new class_3959(pos, pos.method_1019(movement), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)) : MthUtils.collideWithSweptAABB((class_1297)this, movement, 2.0);
        class_243 newPos = hitResult.method_17784();
        this.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        float f = deceleration = this.method_5799() ? this.getWaterInertia() : this.getInertia();
        if (client) {
            this.spawnTrailParticles();
        }
        this.method_18799(this.method_18798().method_1021((double)deceleration));
        if (!this.method_5740() && !this.field_5960) {
            this.method_18799(this.method_18798().method_1023(0.0, (double)this.method_7490(), 0.0));
        }
        this.method_5852();
        if (this.hasReachedEndOfLife() && !this.method_31481()) {
            this.reachedEndOfLife();
        }
        if (this.method_31481()) {
            return;
        }
        class_3966 entityHitResult = class_1675.method_18077((class_1937)level, (class_1297)this, (class_243)pos, (class_243)newPos, (class_238)this.method_5829().method_18804(newPos.method_1020(pos)).method_1014(1.0), x$0 -> this.method_26958((class_1297)x$0));
        if (entityHitResult != null) {
            hitResult = entityHitResult;
        }
        if (hitResult.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        boolean portalHit = false;
        if (hitResult instanceof class_3966) {
            class_3966 ei = (class_3966)hitResult;
            class_1297 hitEntity = ei.method_17782();
            if (hitEntity == this.method_24921()) {
                if (!this.canHarmOwner()) {
                    hitResult = null;
                }
            } else if (hitEntity instanceof class_1657) {
                class_1657 p2;
                class_1657 p1 = (class_1657)hitEntity;
                class_1297 class_12972 = this.method_24921();
                if (class_12972 instanceof class_1657 && !(p2 = (class_1657)class_12972).method_7256(p1)) {
                    hitResult = null;
                }
            }
        } else if (hitResult instanceof class_3965) {
            class_3965 bi = hitResult;
            class_2338 hitPos = bi.method_17777();
            class_2680 hitState = level.method_8320(hitPos);
            if (hitState.method_27852(class_2246.field_10316)) {
                this.method_5717(hitPos);
                portalHit = true;
            } else if (hitState.method_27852(class_2246.field_10613)) {
                class_2586 class_25862 = level.method_8321(hitPos);
                if (class_25862 instanceof class_2643) {
                    class_2643 tile = (class_2643)class_25862;
                    if (class_2643.method_30276((class_1297)this)) {
                        class_2643.method_11409((class_1937)level, (class_2338)hitPos, (class_2680)hitState, (class_1297)this, (class_2643)tile);
                    }
                }
                portalHit = true;
            }
        }
        if (!(portalHit || hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333 || this.field_5960 || ForgeHelper.onProjectileImpact((class_1676)this, (class_239)hitResult))) {
            this.method_7488((class_239)hitResult);
        }
    }

    public boolean canHarmOwner() {
        if (this.method_24921() instanceof class_1657) {
            return this.method_37908().method_8407().method_5461() >= 1;
        }
        return false;
    }

    protected float getInertia() {
        return 0.99f;
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public boolean hasReachedEndOfLife() {
        return this.field_6012 > this.maxAge || this.inBlockTime > this.maxInBlockTime;
    }

    public void reachedEndOfLife() {
        this.method_5650(class_1297.class_5529.field_26999);
    }

    @Deprecated(forRemoval=true)
    public void spawnTrailParticles(class_243 oldPos, class_243 newPos) {
    }

    public void spawnTrailParticles() {
        this.spawnTrailParticles(new class_243(this.field_6014, this.field_6036, this.field_5969), this.method_19538());
        if (this.method_5799()) {
            class_243 movement = this.method_18798();
            double velX = movement.field_1352;
            double velY = movement.field_1351;
            double velZ = movement.field_1350;
            for (int j = 0; j < 4; ++j) {
                double pY = this.method_23320();
                this.method_37908().method_8406((class_2394)class_2398.field_11247, this.method_23317() - velX * 0.25, pY - velY * 0.25, this.method_23321() - velZ * 0.25, velX, velY, velZ);
            }
        }
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("inBlock", this.isInBlock);
        tag.method_10569("inBlockTime", this.inBlockTime);
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        this.isInBlock = tag.method_10577("inBlock");
        this.inBlockTime = tag.method_10550("inBlockTime");
    }

    public void method_24919(class_1297 shooter, float x, float y, float z, float velocity, float inaccuracy) {
        super.method_24919(shooter, x, y, z, velocity, inaccuracy);
    }

    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        super.method_7485(x, y, z, velocity, inaccuracy);
    }

    public float getDefaultShootVelocity() {
        return 1.5f;
    }

    @Deprecated(forRemoval=true)
    public void setNoPhysics(boolean noGravity) {
        super.method_5875(noGravity);
    }

    @Deprecated(forRemoval=true)
    public boolean isNoPhysics() {
        return super.method_5740();
    }

    @Deprecated(forRemoval=true)
    protected float getDeceleration() {
        return 0.99f;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    protected class_3966 findHitEntity(class_243 oPos, class_243 pos) {
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)oPos, (class_243)pos, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), x$0 -> this.method_26958((class_1297)x$0));
    }

    protected ColliderType getColliderType() {
        return ColliderType.AABB;
    }

    protected static enum ColliderType {
        RAY,
        AABB;

    }
}

