/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.vanilla;

import com.endertech.common.CommonCollect;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.Dimensions;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class VanillaOre
implements IHaveConfig {
    protected final UnitConfig config;
    protected final boolean enabled;
    protected final CommonCollect.BlackWhiteList<Biome> biomes;
    protected final CommonCollect.BlackWhiteList<Integer> dimensions;

    public VanillaOre(UnitConfig config) {
        this.config = config;
        String category = this.getClassCategory();
        this.enabled = ForgeConfig.getBool((ForgeConfig)config, (String)category, (String)"enabled", (boolean)true, (String)"Enables / disables the generation of this ore.");
        this.dimensions = Dimensions.from((ForgeConfig)config, (String)category, (String)"Defines the dimensions which this ore can be generated in.");
        this.biomes = Biomes.from((ForgeConfig)config, (String)category, (String)"Defines the biomes which this ore can be generated in.");
        this.saveConfig();
    }

    public ForgeConfig getConfig() {
        return this.config;
    }

    public boolean inAllowableDimenstion(World world) {
        return this.dimensions.isEmpty() || this.dimensions.isAllowed((Object)world.field_73011_w.getDimension());
    }

    public boolean inAllowableBiome(World world, BlockPos pos) {
        return this.biomes.isEmpty() || this.biomes.isAllowed((Object)world.func_180494_b(pos));
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

