/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.registration.reflect;

import io.wispforest.owo.registration.annotations.RegistryNamespace;
import io.wispforest.owo.registration.reflect.AutoRegistryContainer;
import io.wispforest.owo.registration.reflect.FieldProcessingSubject;
import io.wispforest.owo.registration.reflect.SimpleFieldProcessingSubject;
import io.wispforest.owo.util.ReflectionUtils;
import java.lang.reflect.Field;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.logging.log4j.util.TriConsumer;

public class FieldRegistrationHandler {
    public static <T> void process(Class<? extends FieldProcessingSubject<T>> clazz, TriConsumer<T, String, Field> processor, boolean recurseIntoInnerClasses) {
        FieldProcessingSubject<T> handler = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, handler.getTargetFieldType(), FieldRegistrationHandler.createProcessor(processor, handler));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, FieldProcessingSubject.class, subclass -> FieldRegistrationHandler.process(subclass, processor, true));
        }
        handler.afterFieldProcessing();
    }

    public static <T> void processSimple(Class<? extends SimpleFieldProcessingSubject<T>> clazz, boolean recurseIntoInnerClasses) {
        SimpleFieldProcessingSubject<T> handler = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, handler.getTargetFieldType(), FieldRegistrationHandler.createProcessor(handler::processField, handler));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, SimpleFieldProcessingSubject.class, subclass -> FieldRegistrationHandler.processSimple(subclass, true));
        }
        handler.afterFieldProcessing();
    }

    public static <T> void register(Class<? extends AutoRegistryContainer<T>> clazz, String namespace, boolean recurseIntoInnerClasses) {
        AutoRegistryContainer container = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, container.getTargetFieldType(), FieldRegistrationHandler.createProcessor((fieldValue, identifier, field) -> {
            class_2378.method_10230(container.getRegistry(), (class_2960)new class_2960(namespace, identifier), (Object)fieldValue);
            container.postProcessField(namespace, (Object)fieldValue, (String)identifier, (Field)field);
        }, container));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, AutoRegistryContainer.class, subclass -> {
                String classModId = namespace;
                if (subclass.isAnnotationPresent(RegistryNamespace.class)) {
                    classModId = subclass.getAnnotation(RegistryNamespace.class).value();
                }
                FieldRegistrationHandler.register(subclass, classModId, true);
            });
        }
        container.afterFieldProcessing();
    }

    private static <T> ReflectionUtils.FieldConsumer<T> createProcessor(TriConsumer<T, String, Field> delegate, FieldProcessingSubject<T> handler) {
        return (t, u, f) -> {
            if (!handler.shouldProcessField(t, u, f)) {
                return;
            }
            delegate.accept(t, (Object)u, (Object)f);
        };
    }
}

