/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.apache.commons.lang3.mutable.MutableInt;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;

public class AlloyForgeRecipeSerializer
implements class_1865<AlloyForgeRecipe> {
    public static final AlloyForgeRecipeSerializer INSTANCE = new AlloyForgeRecipeSerializer();

    public AlloyForgeRecipe read(class_2960 id, JsonObject json) {
        boolean bl;
        LinkedHashMap<IngredientData, MutableInt> ingredientDataToCount = new LinkedHashMap<IngredientData, MutableInt>();
        for (Object entry : class_3518.method_15261((JsonObject)json, (String)"inputs")) {
            IngredientData inputData;
            JsonObject jsonObject = entry.getAsJsonObject();
            if (jsonObject.has("item")) {
                inputData = new IngredientData(jsonObject.get("item").getAsString(), false);
            } else if (jsonObject.has("tag")) {
                inputData = new IngredientData(jsonObject.get("tag").getAsString(), true);
            } else {
                throw new JsonSyntaxException("An ingredient entry needs either a tag or an item");
            }
            ingredientDataToCount.computeIfAbsent(inputData, stringStringPair -> new MutableInt(0)).add(jsonObject.keySet().contains("count") ? jsonObject.get("count").getAsInt() : 1);
        }
        if (ingredientDataToCount.isEmpty()) {
            throw new JsonSyntaxException("Inputs cannot be empty");
        }
        if (ingredientDataToCount.keySet().size() > 10) {
            throw new JsonSyntaxException("Recipe has more than 10 distinct input ingredients");
        }
        LinkedHashMap<class_1856, Integer> ingredientToCount = new LinkedHashMap<class_1856, Integer>();
        for (Map.Entry entry : ingredientDataToCount.entrySet()) {
            IngredientData ingredientData = (IngredientData)entry.getKey();
            class_2960 identifier = new class_2960(ingredientData.data());
            class_1856 ingredient = ingredientData.isTag() ? class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)identifier)) : class_1856.method_8091((class_1935[])new class_1935[]{class_3518.method_15256((JsonElement)new JsonPrimitive(ingredientData.data()), (String)identifier.toString())});
            ingredientToCount.put(ingredient, ((MutableInt)entry.getValue()).intValue());
        }
        if (ingredientToCount.values().stream().mapToInt(integer -> integer).sum() > 640) {
            throw new JsonSyntaxException("Recipe exceeded maximum input item count of 640");
        }
        JsonObject outputObject = class_3518.method_15296((JsonObject)json, (String)"output");
        boolean bl2 = false;
        class_1799 outputStack = null;
        class_3545 defaultTag = null;
        if (outputObject.has("priority")) {
            if (!outputObject.has("default")) {
                throw new JsonSyntaxException("Priority-based recipes must declare a 'default' tag");
            }
            bl = true;
            for (JsonElement itemElement : class_3518.method_15261((JsonObject)outputObject, (String)"priority")) {
                Optional maybeItem = class_2378.field_11142.method_17966(class_2960.method_12829((String)itemElement.getAsString()));
                if (!maybeItem.isPresent()) continue;
                outputStack = ((class_1792)maybeItem.get()).method_7854();
                outputStack.method_7939(class_3518.method_15260((JsonObject)outputObject, (String)"count"));
                break;
            }
            if (outputStack == null) {
                defaultTag = new class_3545((Object)class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(class_3518.method_15265((JsonObject)outputObject, (String)"default"))), (Object)class_3518.method_15260((JsonObject)outputObject, (String)"count"));
            }
        } else {
            outputStack = this.getItemStack(outputObject);
        }
        int minForgeTier = class_3518.method_15260((JsonObject)json, (String)"min_forge_tier");
        int requiredFuel = class_3518.method_15260((JsonObject)json, (String)"fuel_per_tick");
        JsonObject overrides = class_3518.method_15281((JsonObject)json, (String)"overrides", (JsonObject)new JsonObject());
        ImmutableMap.Builder overridesBuilder = ImmutableMap.builder();
        for (Map.Entry entry : overrides.entrySet()) {
            String overrideString = (String)entry.getKey();
            AlloyForgeRecipe.OverrideRange overrideRange = null;
            if (overrideString.matches("\\d+\\+")) {
                overrideRange = new AlloyForgeRecipe.OverrideRange(Integer.parseInt(overrideString.substring(0, overrideString.length() - 1)));
            } else if (overrideString.matches("\\d+ to \\d+")) {
                overrideRange = new AlloyForgeRecipe.OverrideRange(Integer.parseInt(overrideString.substring(0, overrideString.indexOf(" "))), Integer.parseInt(overrideString.substring(overrideString.lastIndexOf(" ") + 1, overrideString.length())));
            } else if (overrideString.matches("\\d+")) {
                overrideRange = new AlloyForgeRecipe.OverrideRange(Integer.parseInt(overrideString), Integer.parseInt(overrideString));
            }
            if (overrideRange == null) {
                throw new JsonSyntaxException("Invalid override range token: " + overrideString);
            }
            JsonObject overrideObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            if (overrideObject.has("id")) {
                overridesBuilder.put((Object)overrideRange, (Object)AlloyForgeRecipe.PendingRecipeData.PendingOverride.ofStack(this.getItemStack(overrideObject)));
                continue;
            }
            overridesBuilder.put((Object)overrideRange, (Object)AlloyForgeRecipe.PendingRecipeData.PendingOverride.onlyCount(class_3518.method_15260((JsonObject)overrideObject, (String)"count")));
        }
        ImmutableMap effectiveOverrides = ImmutableMap.of();
        if (!bl) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : overridesBuilder.build().entrySet()) {
                if (((AlloyForgeRecipe.PendingRecipeData.PendingOverride)entry.getValue()).isCountOnly()) {
                    class_1799 stack = outputStack.method_7972();
                    stack.method_7939(((AlloyForgeRecipe.PendingRecipeData.PendingOverride)entry.getValue()).count());
                    builder.put((Object)((AlloyForgeRecipe.OverrideRange)entry.getKey()), (Object)stack);
                    continue;
                }
                builder.put((Object)((AlloyForgeRecipe.OverrideRange)entry.getKey()), (Object)((AlloyForgeRecipe.PendingRecipeData.PendingOverride)entry.getValue()).stack());
            }
            effectiveOverrides = builder.build();
        }
        AlloyForgeRecipe recipe = new AlloyForgeRecipe(id, ingredientToCount, outputStack, minForgeTier, requiredFuel, (ImmutableMap<AlloyForgeRecipe.OverrideRange, class_1799>)effectiveOverrides);
        if (bl) {
            AlloyForgeRecipe.PENDING_RECIPES.put(recipe, new AlloyForgeRecipe.PendingRecipeData((class_3545<class_6862<class_1792>, Integer>)defaultTag, (ImmutableMap<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingRecipeData.PendingOverride>)overridesBuilder.build()));
        }
        return recipe;
    }

    private class_1799 getItemStack(JsonObject json) {
        class_1792 item = class_3518.method_15288((JsonObject)json, (String)"id");
        int count = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
        return new class_1799((class_1935)item, count);
    }

    public AlloyForgeRecipe read(class_2960 id, class_2540 buf) {
        LinkedHashMap inputs = (LinkedHashMap)buf.method_34069(value -> new LinkedHashMap(), class_1856::method_8086, class_2540::method_10816);
        class_1799 output = buf.method_10819();
        int minForgeTier = buf.method_10816();
        int requiredFuel = buf.method_10816();
        Map overrides = buf.method_34067(buf1 -> new AlloyForgeRecipe.OverrideRange(buf1.method_10816(), buf1.method_10816()), class_2540::method_10819);
        return new AlloyForgeRecipe(id, inputs, output, minForgeTier, requiredFuel, (ImmutableMap<AlloyForgeRecipe.OverrideRange, class_1799>)ImmutableMap.copyOf((Map)overrides));
    }

    public void write(class_2540 buf, AlloyForgeRecipe recipe) {
        buf.method_34063(recipe.getIngredientsMap(), (buf1, ingredient) -> ingredient.method_8088(buf1), class_2540::method_10804);
        buf.method_10793(recipe.method_8110());
        buf.method_10804(recipe.getMinForgeTier());
        buf.method_10804(recipe.getFuelPerTick());
        buf.method_34063(recipe.getTierOverrides(), (buf1, overrideRange) -> {
            buf1.method_10804(overrideRange.lowerBound());
            buf1.method_10804(overrideRange.upperBound());
        }, class_2540::method_10793);
    }

    private record IngredientData(String data, boolean isTag) {
    }
}

