/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.forges;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.wispforest.owo.registration.ComplexRegistryAction;
import io.wispforest.owo.registration.RegistryHelper;
import java.util.ArrayList;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import wraith.alloyforgery.forges.ForgeRegistry;

public record ForgeDefinition(int forgeTier, float speedMultiplier, int fuelCapacity, int maxSmeltTime, class_2248 material, ImmutableList<class_2248> additionalMaterials) {
    private static final int BASE_MAX_SMELT_TIME = 200;
    private static final String RECIPE_PATTERN = "{\n    \"type\": \"minecraft:crafting_shaped\",\n    \"pattern\": [\n        \"###\",\n        \"#B#\",\n        \"###\"\n    ],\n    \"key\": {\n        \"#\": {\n            \"item\": \"{material}\"\n        },\n        \"B\": {\n            \"item\": \"minecraft:blast_furnace\"\n        }\n    },\n    \"result\": {\n        \"item\": \"{controller}\",\n        \"count\": 1\n    }\n}\n";

    private ForgeDefinition(int forgeTier, float speedMultiplier, int fuelCapacity, class_2248 material, ImmutableList<class_2248> additionalMaterials) {
        this(forgeTier, speedMultiplier, fuelCapacity, (int)(200.0f / speedMultiplier), material, additionalMaterials);
    }

    public static void loadAndEnqueue(class_2960 id, JsonObject json) {
        int forgeTier = class_3518.method_15260((JsonObject)json, (String)"tier");
        float speedMultiplier = class_3518.method_15277((JsonObject)json, (String)"speed_multiplier", (float)1.0f);
        int fuelCapacity = class_3518.method_15282((JsonObject)json, (String)"fuel_capacity", (int)48000);
        class_2960 mainMaterialId = class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"material"));
        ArrayList additionalMaterialIds = new ArrayList();
        class_3518.method_15292((JsonObject)json, (String)"additional_materials", (JsonArray)new JsonArray()).forEach(jsonElement -> additionalMaterialIds.add(class_2960.method_12829((String)jsonElement.getAsString())));
        ComplexRegistryAction action = ComplexRegistryAction.Builder.create(() -> {
            class_2248 mainMaterial = (class_2248)class_2378.field_11146.method_10223(mainMaterialId);
            ImmutableList.Builder additionalMaterialsBuilder = new ImmutableList.Builder();
            additionalMaterialIds.forEach(identifier -> additionalMaterialsBuilder.add((Object)((class_2248)class_2378.field_11146.method_10223(identifier))));
            ForgeDefinition definition = new ForgeDefinition(forgeTier, speedMultiplier, fuelCapacity, mainMaterial, (ImmutableList<class_2248>)additionalMaterialsBuilder.build());
            ForgeRegistry.registerDefinition(id, definition);
        }).entry(mainMaterialId).entries(additionalMaterialIds).build();
        RegistryHelper.get((class_2378)class_2378.field_11146).runWhenPresent(action);
    }

    public boolean isBlockValid(class_2248 block) {
        return block == this.material || this.additionalMaterials.contains((Object)block);
    }

    public JsonElement generateRecipe(class_2960 id) {
        String recipe = RECIPE_PATTERN.replace("{material}", class_2378.field_11142.method_10221((Object)this.material.method_8389()).toString());
        recipe = recipe.replace("{controller}", class_2378.field_11142.method_10221((Object)ForgeRegistry.getControllerBlock(id).get().method_8389()).toString());
        return (JsonElement)ForgeRegistry.GSON.fromJson(recipe, JsonObject.class);
    }

    @Override
    public String toString() {
        return "ForgeDefinition{forgeTier=" + this.forgeTier + ", speedMultiplier=" + this.speedMultiplier + ", fuelCapacity=" + this.fuelCapacity + ", maxSmeltTime=" + this.maxSmeltTime + ", material=" + this.material + ", additionalMaterials=" + this.additionalMaterials + "}";
    }
}

