/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.slf4j.Logger;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;

public class AlloyForgeryGlobalRemaindersLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public AlloyForgeryGlobalRemaindersLoader() {
        super(GSON, "forge_remainder");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        prepared.forEach((identifier, jsonElement) -> {
            try {
                HashMap<class_1792, class_1799> remainders;
                if (jsonElement instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    if (!jsonObject.has("remainders")) {
                        throw new JsonSyntaxException("The Global Remainders file seems to be missing the needed remainders field.");
                    }
                    remainders = new HashMap<class_1792, class_1799>();
                    for (Map.Entry remainderEntry : jsonObject.getAsJsonObject("remainders").entrySet()) {
                        class_1792 item = class_3518.method_15256((JsonElement)new JsonPrimitive((String)remainderEntry.getKey()), (String)((String)remainderEntry.getKey()));
                        if (((JsonElement)remainderEntry.getValue()).isJsonObject()) {
                            class_1799 remainderStack = class_1869.method_35228((JsonObject)((JsonElement)remainderEntry.getValue()).getAsJsonObject());
                            remainders.put(item, remainderStack);
                            continue;
                        }
                        class_1792 remainderItem = class_3518.method_15256((JsonElement)((JsonElement)remainderEntry.getValue()), (String)"item");
                        remainders.put(item, new class_1799((class_1935)remainderItem));
                    }
                } else {
                    throw new JsonSyntaxException("JsonElement wasn't a JsonObject meaning it is malformed");
                }
                AlloyForgeRecipe.addRemainders(remainders);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error("[AlloyForgerRemainders]: Parsing error loading recipe {}", identifier, (Object)exception);
            }
        });
    }

    public class_2960 getFabricId() {
        return new class_2960("alloy_forgery", "forge_remainder");
    }
}

