/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.compat.rei;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import wraith.alloyforgery.compat.rei.AlloyForgingCategory;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;

public class AlloyForgingDisplay
implements Display {
    private final List<EntryIngredient> inputs;
    private final EntryIngredient output;
    public final int minForgeTier;
    public final int requiredFuel;
    public final Map<AlloyForgeRecipe.OverrideRange, class_1799> overrides;

    public AlloyForgingDisplay(AlloyForgeRecipe recipe) {
        ArrayList<EntryIngredient> convertedInputs = new ArrayList<EntryIngredient>();
        for (Map.Entry<class_1856, Integer> entry : recipe.getIngredientsMap().entrySet()) {
            int stackCount;
            for (int i = entry.getValue().intValue(); i > 0; i -= stackCount) {
                stackCount = Math.min(i, 64);
                convertedInputs.add(EntryIngredients.ofItemStacks(Arrays.stream(entry.getKey().method_8105()).map(class_1799::method_7972).peek(stack -> stack.method_7939(stackCount)).toList()));
            }
        }
        this.inputs = convertedInputs;
        this.output = EntryIngredients.of((class_1799)recipe.method_8110());
        this.minForgeTier = recipe.getMinForgeTier();
        this.requiredFuel = recipe.getFuelPerTick();
        this.overrides = recipe.getTierOverrides();
    }

    public AlloyForgingDisplay(List<EntryIngredient> inputs, EntryIngredient output, int minForgeTier, int requiredFuel, Map<AlloyForgeRecipe.OverrideRange, class_1799> overrides) {
        this.inputs = inputs;
        this.output = output;
        this.minForgeTier = minForgeTier;
        this.requiredFuel = requiredFuel;
        this.overrides = overrides;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(this.output);
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return AlloyForgingCategory.ID;
    }

    public static enum Serializer implements DisplaySerializer<AlloyForgingDisplay>
    {
        INSTANCE;


        public class_2487 save(class_2487 tag, AlloyForgingDisplay display) {
            tag.method_10569("fuel_per_tick", display.requiredFuel);
            tag.method_10569("min_forge_tier", display.minForgeTier);
            class_2499 inputs = new class_2499();
            inputs.addAll(display.inputs.stream().map(EntryIngredient::save).toList());
            tag.method_10566("inputs", (class_2520)inputs);
            tag.method_10566("output", (class_2520)display.output.save());
            class_2499 overrides = new class_2499();
            display.overrides.forEach((overrideRange, itemStack) -> {
                class_2487 overrideTag = new class_2487();
                overrideTag.method_10569("lower", overrideRange.lowerBound());
                overrideTag.method_10569("upper", overrideRange.upperBound());
                overrideTag.method_10566("stack", (class_2520)itemStack.method_7948());
                overrides.add((Object)overrideTag);
            });
            tag.method_10566("overrides", (class_2520)overrides);
            return tag;
        }

        public AlloyForgingDisplay read(class_2487 tag) {
            int requiredFuel = tag.method_10550("fuel_per_tick");
            int minForgeTier = tag.method_10550("fuel_per_tick");
            ArrayList<EntryIngredient> input = new ArrayList<EntryIngredient>();
            tag.method_10554("inputs", 9).forEach(nbtElement -> input.add(EntryIngredient.read((class_2499)((class_2499)nbtElement))));
            EntryIngredient output = EntryIngredient.read((class_2499)tag.method_10554("output", 9));
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            tag.method_10554("overrides", 10).forEach(nbtElement -> {
                class_2487 overrideTag = (class_2487)nbtElement;
                AlloyForgeRecipe.OverrideRange range = new AlloyForgeRecipe.OverrideRange(overrideTag.method_10550("lower"), overrideTag.method_10550("upper"));
                class_1799 stack = class_1799.method_7915((class_2487)overrideTag.method_10562("stack"));
                builder.put((Object)range, (Object)stack);
            });
            return new AlloyForgingDisplay(input, output, minForgeTier, requiredFuel, (Map<AlloyForgeRecipe.OverrideRange, class_1799>)builder.build());
        }
    }
}

