/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lukebemish.dynamic_asset_generator.client.api.ClientPrePackRepository;
import io.github.lukebemish.dynamic_asset_generator.client.api.DynAssetGeneratorClientAPI;
import io.github.lukebemish.dynamic_asset_generator.client.api.ForegroundTransferType;
import io.github.lukebemish.dynamic_asset_generator.client.api.PaletteExtractor;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.ModifiedOreBlock;
import io.github.lukebemish.excavated_variants.client.BackupFetcher;
import io.github.lukebemish.excavated_variants.client.BlockModelParser;
import io.github.lukebemish.excavated_variants.client.BlockstateModelParser;
import io.github.lukebemish.excavated_variants.client.ResettingHolder;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import io.github.lukebemish.excavated_variants.util.Pair;
import io.github.lukebemish.excavated_variants.util.Triple;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_790;
import net.minecraft.class_807;
import net.minecraft.class_813;

public class BlockStateAssembler {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private static volatile Map<class_2960, Supplier<InputStream>> intMap;
    private static Collection<Pair<BaseOre, BaseStone>> int_original_pairs;
    private static List<Pair<BaseOre, BaseStone>> int_to_make;

    public static void setupClientAssets(Collection<Pair<BaseOre, BaseStone>> original_pairs, List<Pair<BaseOre, BaseStone>> to_make) {
        int_original_pairs = original_pairs;
        int_to_make = to_make;
        for (Pair<BaseOre, BaseStone> p : to_make) {
            String full_id = p.last().id + "_" + p.first().id;
            int max_tex_num = p.first().texture_count * p.last().texture_count;
            ArrayList<class_2960> targets = new ArrayList<class_2960>(List.of(new class_2960("excavated_variants", "blockstates/" + full_id + ".json")));
            for (int i = 0; i < max_tex_num; ++i) {
                targets.add(new class_2960("excavated_variants", "models/block/" + full_id + i + ".json"));
                targets.add(new class_2960("excavated_variants", "textures/block/" + full_id + i + ".png"));
            }
            for (class_2960 rl : targets) {
                DynAssetGeneratorClientAPI.planLoadingStream((class_2960)rl, (Supplier)((Object)new ResettingHolder(rl)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<class_2960, Supplier<InputStream>> updateMap() {
        if (intMap != null) return intMap;
        Class<BlockStateAssembler> clazz = BlockStateAssembler.class;
        synchronized (BlockStateAssembler.class) {
            if (intMap != null) return intMap;
            intMap = BlockStateAssembler.getMap(int_original_pairs, int_to_make);
            // ** MonitorExit[var0] (shouldn't be in output)
            return intMap;
        }
    }

    public static void reset() {
        intMap = null;
    }

    private static Map<class_2960, Supplier<InputStream>> getMap(Collection<Pair<BaseOre, BaseStone>> original_pairs, List<Pair<BaseOre, BaseStone>> to_make) {
        class_2960 stoneRl;
        class_2960 oreRl;
        BaseOre ore;
        class_790.class_791 ctx = new class_790.class_791();
        HashMap<class_2960, Supplier<InputStream>> resources = new HashMap<class_2960, Supplier<InputStream>>();
        HashMap<String, Pair<class_790, List<class_2960>>> oreInfoMap = new HashMap<String, Pair<class_790, List<class_2960>>>();
        HashMap<String, Pair<class_790, List<class_2960>>> stoneInfoMap = new HashMap<String, Pair<class_790, List<class_2960>>>();
        HashMap extractorMap = new HashMap();
        for (Pair<BaseOre, BaseStone> p : to_make) {
            ore = p.first();
            BaseStone stone = p.last();
            try {
                if (!oreInfoMap.containsKey(ore.id)) {
                    oreRl = ore.block_id.get(0);
                    oreInfoMap.put(ore.id, BlockStateAssembler.getInfoFromBlockstate(oreRl, ctx));
                }
                if (stoneInfoMap.containsKey(stone.id)) continue;
                stoneRl = stone.block_id;
                stoneInfoMap.put(stone.id, BlockStateAssembler.getInfoFromBlockstate(stoneRl, ctx));
            }
            catch (IOException e) {
                ExcavatedVariants.LOGGER.info((Object)e);
            }
        }
        for (Pair<BaseOre, BaseStone> p : original_pairs) {
            ore = p.first();
            BaseStone base = p.last();
            try {
                if (!oreInfoMap.containsKey(ore.id)) {
                    oreRl = ore.block_id.get(0);
                    oreInfoMap.put(ore.id, BlockStateAssembler.getInfoFromBlockstate(oreRl, ctx));
                }
                if (!stoneInfoMap.containsKey(base.id)) {
                    stoneRl = base.block_id;
                    stoneInfoMap.put(base.id, BlockStateAssembler.getInfoFromBlockstate(stoneRl, ctx));
                }
                Pair stoneInfo = (Pair)stoneInfoMap.get(base.id);
                Pair oreInfo = (Pair)oreInfoMap.get(ore.id);
                if (stoneInfo != null && oreInfo != null && ((List)stoneInfo.last()).size() >= 1 && ((List)oreInfo.last()).size() >= 1) {
                    ArrayList<Triple<Object, class_2960, Boolean>> extractors = new ArrayList<Triple<Object, class_2960, Boolean>>();
                    extractorMap.put(ore.id, extractors);
                    for (class_2960 rl : (List)oreInfo.last()) {
                        InputStream is = ClientPrePackRepository.getResource((class_2960)rl);
                        class_1011 img = class_1011.method_4309((InputStream)is);
                        boolean isTransparent = false;
                        block18: for (int x2 = 0; x2 < img.method_4307(); ++x2) {
                            for (int y = 0; y < img.method_4323(); ++y) {
                                int c = img.method_4315(x2, y);
                                float alpha = (float)(c >> 24 & 0xFF) / 255.0f;
                                if (!(alpha < 0.5f)) continue;
                                isTransparent = true;
                                break block18;
                            }
                        }
                        PaletteExtractor extractor = isTransparent ? null : new PaletteExtractor((class_2960)((List)stoneInfo.last()).get(0), rl, 6, true, true, 0.2).fillHoles(true);
                        extractors.add(new Triple<Object, class_2960, Boolean>(extractor, rl, !isTransparent));
                    }
                    continue;
                }
                ExcavatedVariants.LOGGER.warn("Bad info while extracting from blocks {} and {}:{}", (Object)ore.block_id.get(0).toString(), (Object)base.block_id.toString(), (Object)((stoneInfo == null ? "\nMissing stone block model info" : "") + (oreInfo == null ? "\nMissing ore block model info" : "") + (stoneInfo != null && ((List)stoneInfo.last()).size() < 1 ? "\nNo stone textures found" : "") + (oreInfo != null && ((List)oreInfo.last()).size() < 1 ? "\nNo ore textures found" : "")));
            }
            catch (IOException e) {
                ExcavatedVariants.LOGGER.info((Object)e);
            }
            catch (JsonSyntaxException e) {
                ExcavatedVariants.LOGGER.error((Object)e);
            }
        }
        for (Pair<BaseOre, BaseStone> p : to_make) {
            Pair oreInfo = (Pair)oreInfoMap.get(p.first().id);
            Pair stoneInfo = (Pair)stoneInfoMap.get(p.last().id);
            ArrayList extractorPair = (ArrayList)extractorMap.get(p.first().id);
            BaseStone stone = p.last();
            BaseOre ore2 = p.first();
            String full_id = stone.id + "_" + ore2.id;
            ModifiedOreBlock outBlock = ExcavatedVariants.getBlocks().get(full_id);
            if (oreInfo != null && stoneInfo != null && extractorPair != null && outBlock != null) {
                Object stoneBG22;
                HashMap<Pair<Object, class_2960>, class_2960> texMap = new HashMap<Pair<Object, class_2960>, class_2960>();
                int index = 0;
                for (Object stoneBG22 : (List)stoneInfo.last()) {
                    for (Triple exp : extractorPair) {
                        if (((Boolean)exp.last()).booleanValue()) {
                            ForegroundTransferType plan = new ForegroundTransferType((PaletteExtractor)exp.first(), (class_2960)stoneBG22, true, false);
                            class_2960 outRL = new class_2960("excavated_variants", "textures/block/" + full_id + index + ".png");
                            ++index;
                            resources.put(outRL, (Supplier<InputStream>)plan.getStream(outRL));
                            texMap.put(new Pair<Object, class_2960>(stoneBG22, (class_2960)exp.second()), outRL);
                            continue;
                        }
                        texMap.put(new Pair<Object, class_2960>(stoneBG22, (class_2960)exp.second()), (class_2960)exp.second());
                    }
                }
                HashMap<Pair<class_2960, class_2960>, class_2960> newTexMap = new HashMap<Pair<class_2960, class_2960>, class_2960>();
                stoneBG22 = texMap.keySet().iterator();
                while (stoneBG22.hasNext()) {
                    Pair pair = (Pair)stoneBG22.next();
                    String p1 = ((class_2960)pair.first()).method_12832().substring(9);
                    p1 = p1.substring(0, p1.length() - 4);
                    class_2960 rl1 = new class_2960(((class_2960)pair.first()).method_12836(), p1);
                    p1 = ((class_2960)pair.last()).method_12832().substring(9);
                    p1 = p1.substring(0, p1.length() - 4);
                    class_2960 rl2 = new class_2960(((class_2960)pair.last()).method_12836(), p1);
                    p1 = ((class_2960)texMap.get(pair)).method_12832().substring(9);
                    p1 = p1.substring(0, p1.length() - 4);
                    class_2960 rl3 = new class_2960(((class_2960)texMap.get(pair)).method_12836(), p1);
                    newTexMap.put(new Pair<class_2960, class_2960>(rl1, rl2), rl3);
                }
                List<class_2960> defaultModels = ((class_807)((class_790)oreInfo.first()).method_35791().stream().findFirst().get()).method_3497().stream().map(class_813::method_3510).toList();
                class_2960 stoneModel = ((class_807)((class_790)stoneInfo.first()).method_35791().stream().findFirst().get()).method_3497().stream().map(class_813::method_3510).findFirst().get();
                ArrayList<class_2960> outModelRLs = new ArrayList<class_2960>();
                try {
                    InputStream read;
                    try {
                        read = ClientPrePackRepository.getResource((class_2960)new class_2960(stoneModel.method_12836(), "models/" + stoneModel.method_12832() + ".json"));
                    }
                    catch (IOException e) {
                        read = BackupFetcher.provideBlockModelFile(stoneModel);
                    }
                    BlockModelParser parentModel = (BlockModelParser)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(read, StandardCharsets.UTF_8)), BlockModelParser.class);
                    List<class_2960> stoneLocs = parentModel.textures.values().stream().map(x -> class_2960.method_12838((String)x, (char)':')).toList();
                    int i2 = 0;
                    for (class_2960 m : defaultModels) {
                        InputStream oreRead;
                        InputStream stoneRead;
                        try {
                            stoneRead = ClientPrePackRepository.getResource((class_2960)new class_2960(stoneModel.method_12836(), "models/" + stoneModel.method_12832() + ".json"));
                        }
                        catch (IOException e) {
                            stoneRead = BackupFetcher.provideBlockModelFile(stoneModel);
                        }
                        BlockModelParser outputModel = (BlockModelParser)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(stoneRead, StandardCharsets.UTF_8)), BlockModelParser.class);
                        try {
                            stoneRead = ClientPrePackRepository.getResource((class_2960)new class_2960(stoneModel.method_12836(), "models/" + stoneModel.method_12832() + ".json"));
                        }
                        catch (IOException e) {
                            stoneRead = BackupFetcher.provideBlockModelFile(stoneModel);
                        }
                        JsonObject outputMap = (JsonObject)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(stoneRead, StandardCharsets.UTF_8)), JsonObject.class);
                        try {
                            oreRead = ClientPrePackRepository.getResource((class_2960)new class_2960(m.method_12836(), "models/" + m.method_12832() + ".json"));
                        }
                        catch (IOException e) {
                            oreRead = BackupFetcher.provideBlockModelFile(m);
                        }
                        StringBuilder oreTextBuilder = new StringBuilder();
                        BufferedReader oreReader = new BufferedReader(new InputStreamReader(oreRead, Charset.forName(StandardCharsets.UTF_8.name())));
                        int oreC = 0;
                        while ((oreC = ((Reader)oreReader).read()) != -1) {
                            oreTextBuilder.append((char)oreC);
                        }
                        BlockModelParser oreModel = (BlockModelParser)GSON.fromJson(oreTextBuilder.toString(), BlockModelParser.class);
                        String maybeTex = oreModel.textures.values().stream().filter(x -> !stoneLocs.contains(class_2960.method_12838((String)x, (char)':')) && newTexMap.keySet().stream().anyMatch(y -> {
                            class_2960 rl = class_2960.method_12838((String)x, (char)':');
                            return ((class_2960)y.last()).equals((Object)rl);
                        })).findFirst().orElse(null);
                        class_2960 mainOreTex = maybeTex == null ? null : class_2960.method_12838((String)maybeTex, (char)':');
                        List<String> overlayTextures = oreModel.textures.values().stream().filter(x -> newTexMap.entrySet().stream().anyMatch(e -> {
                            Pair y = (Pair)e.getKey();
                            class_2960 rl = class_2960.method_12838((String)x, (char)':');
                            return ((class_2960)y.last()).equals((Object)rl) && ((class_2960)y.last()).equals(e.getValue());
                        })).toList();
                        for (String string : outputModel.textures.keySet()) {
                            String val = outputModel.textures.get(string);
                            class_2960 old = class_2960.method_12838((String)val, (char)':');
                            class_2960 lookup = (class_2960)newTexMap.get(new Pair<class_2960, class_2960>(old, mainOreTex));
                            if (lookup == null) continue;
                            outputModel.replaceTexture(old, lookup);
                        }
                        int i = 0;
                        for (String s3 : overlayTextures) {
                            class_2960 rl = class_2960.method_12838((String)s3, (char)':');
                            outputModel.addOverlay(i, rl);
                            ++i;
                        }
                        outputMap.add("textures", GSON.toJsonTree(outputModel.textures));
                        if (outputModel.elements != null && outputModel.elements.size() != 0) {
                            outputMap.add("elements", (JsonElement)outputModel.elements);
                        }
                        class_2960 class_29602 = new class_2960("excavated_variants", "block/" + full_id + i2);
                        outModelRLs.add(class_29602);
                        String finalJson = GSON.toJson((JsonElement)outputMap);
                        resources.put(new class_2960("excavated_variants", "models/" + class_29602.method_12832() + ".json"), () -> new ByteArrayInputStream(finalJson.getBytes()));
                        ++i2;
                    }
                    BlockstateModelParser assembler = BlockstateModelParser.create(outBlock, outModelRLs);
                    String bs = GSON.toJson((Object)assembler);
                    resources.put(new class_2960("excavated_variants", "blockstates/" + full_id + ".json"), () -> new ByteArrayInputStream(bs.getBytes()));
                }
                catch (IOException e) {
                    ExcavatedVariants.LOGGER.error((Object)e);
                }
                continue;
            }
            ExcavatedVariants.LOGGER.warn("Missing {}for ore {}", (Object)((oreInfo == null ? "ore model info, " : "") + (stoneInfo == null ? "stone model info, " : "") + (extractorPair == null ? "texture extractor info, " : "") + (outBlock == null ? "registered block, " : "")), (Object)full_id);
        }
        return resources;
    }

    private static Pair<class_790, List<class_2960>> getInfoFromBlockstate(class_2960 oreRl, class_790.class_791 ctx) throws IOException {
        InputStream oreBSIS;
        class_2960 oreBS = new class_2960(oreRl.method_12836(), "blockstates/" + oreRl.method_12832() + ".json");
        try {
            oreBSIS = ClientPrePackRepository.getResource((class_2960)oreBS);
        }
        catch (IOException e) {
            oreBSIS = BackupFetcher.provideBlockstateFile(oreRl);
        }
        class_790 oreBMD = class_790.method_3424((class_790.class_791)ctx, (Reader)new BufferedReader(new InputStreamReader(oreBSIS, StandardCharsets.UTF_8)));
        if (!oreBMD.method_3422()) {
            HashSet oreModels = new HashSet();
            for (Map.Entry e : oreBMD.method_3423().entrySet()) {
                oreModels.addAll(((class_807)e.getValue()).method_4755());
            }
            ArrayList<class_2960> oreTextures = new ArrayList<class_2960>();
            for (class_2960 mRl : oreModels) {
                InputStream is;
                class_2960 actual = new class_2960(mRl.method_12836(), "models/" + mRl.method_12832() + ".json");
                try {
                    is = ClientPrePackRepository.getResource((class_2960)actual);
                }
                catch (IOException e) {
                    is = BackupFetcher.provideBlockModelFile(mRl);
                }
                BlockModelParser map = (BlockModelParser)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)), BlockModelParser.class);
                if (map.textures == null) continue;
                for (String i : map.textures.values()) {
                    class_2960 o = class_2960.method_12838((String)i, (char)':');
                    oreTextures.add(new class_2960(o.method_12836(), "textures/" + o.method_12832() + ".png"));
                }
            }
            return new Pair<class_790, List<class_2960>>(oreBMD, oreTextures);
        }
        return null;
    }
}

