/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants;

import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import io.github.lukebemish.excavated_variants.mixin.IBlockPropertiesMixin;
import io.github.lukebemish.excavated_variants.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2431;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class ModifiedOreBlock
extends class_2431 {
    public final BaseOre ore;
    public final BaseStone stone;
    protected class_2248 target;
    protected class_2248 stoneTarget;
    static class_2769<?>[] staticProps;
    private boolean isLit = false;
    private boolean isHorizontalFacing = false;
    private boolean isFacing = false;
    private boolean isHopperFacing = false;
    private boolean isAxis = false;
    private boolean isHorizontalAxis = false;
    private class_2769<?>[] props;

    public ModifiedOreBlock(BaseOre ore, BaseStone stone) {
        super(ModifiedOreBlock.copyProperties(ore, stone));
        this.ore = ore;
        this.stone = stone;
        if (staticProps != null) {
            this.props = (class_2769[])staticProps.clone();
            staticProps = null;
            this.copyBlockstateDefs();
        }
    }

    private static float avgF(float a, float b) {
        return (a + b) / 2.0f;
    }

    private static class_3620 avgColor(class_3620 a, class_3620 b, float weight) {
        int avgColor = (int)((float)a.method_15820(class_3620.class_6594.field_34761) * weight + (float)b.method_15820(class_3620.class_6594.field_34761) * (1.0f - weight));
        int lowest = 0;
        int lowDiff = 0xFFFFFF;
        for (int i = 0; i < 64; ++i) {
            class_3620 c = class_3620.method_38479((int)i);
            int diff = Math.abs(c.method_15820(class_3620.class_6594.field_34761) - avgColor);
            if (diff >= lowDiff) continue;
            lowDiff = diff;
            lowest = i;
        }
        return class_3620.method_38479((int)lowest);
    }

    private static class_4970.class_2251 copyProperties(BaseOre ore, BaseStone stone) {
        class_2248 target = Services.REGISTRY_UTIL.getBlockById(ore.block_id.get(0));
        class_2248 stoneTarget = Services.REGISTRY_UTIL.getBlockById(stone.block_id);
        if (target != null && stoneTarget != null) {
            class_4970.class_2251 properties = class_4970.class_2251.method_9630((class_4970)stoneTarget);
            class_4970.class_2251 oreProperties = class_4970.class_2251.method_9630((class_4970)target);
            properties.method_29292();
            IBlockPropertiesMixin newProperties = (IBlockPropertiesMixin)properties;
            IBlockPropertiesMixin oreProps = (IBlockPropertiesMixin)oreProperties;
            properties.method_9629(ModifiedOreBlock.avgF(target.method_36555(), stoneTarget.method_36555()), ModifiedOreBlock.avgF(target.method_9520(), stoneTarget.method_9520())).method_31710(ModifiedOreBlock.avgColor(stoneTarget.method_26403(), target.method_26403(), 0.8f));
            newProperties.setDynamicShape(false);
            newProperties.setHasCollision(true);
            newProperties.setIsRandomlyTicking(oreProps.getIsRandomlyTicking());
            newProperties.setLightEmission(oreProps.getLightEmission());
            return properties;
        }
        return class_4970.class_2251.method_9637((class_3614)class_3614.field_15914).method_29292().method_9629(3.0f, 3.0f);
    }

    public static void setupStaticWrapper(BaseOre ore, BaseStone stone) {
        class_2248 target = Services.REGISTRY_UTIL.getBlockById(ore.block_id.get(0));
        class_2248 stoneTarget = Services.REGISTRY_UTIL.getBlockById(stone.block_id);
        if (target != null && stoneTarget != null) {
            ArrayList<class_2769> propBuilder = new ArrayList<class_2769>();
            for (class_2769 p : target.method_9564().method_28501()) {
                if (p != class_2741.field_12548) continue;
                propBuilder.add(p);
            }
            for (class_2769 p : stoneTarget.method_9564().method_28501()) {
                if (p != class_2741.field_12496 && p != class_2741.field_12529 && p != class_2741.field_12525 && p != class_2741.field_12545 && p != class_2741.field_12481) continue;
                propBuilder.add(p);
            }
            staticProps = propBuilder.toArray(new class_2769[0]);
        } else {
            ExcavatedVariants.LOGGER.warn("Could not find block properties for: {}, {}", (Object)ore.block_id.get(0), (Object)stone.block_id);
        }
    }

    public void copyBlockstateDefs() {
        if (this.target == null || this.stoneTarget == null) {
            this.target = Services.REGISTRY_UTIL.getBlockById(this.ore.block_id.get(0));
            this.stoneTarget = Services.REGISTRY_UTIL.getBlockById(this.stone.block_id);
        }
        if (this.target != null && this.stoneTarget != null) {
            class_2680 bs = this.method_9564();
            for (class_2769<?> p : this.props) {
                if (p == class_2741.field_12548) {
                    this.isLit = true;
                    bs = (class_2680)bs.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false));
                }
                if (p == class_2741.field_12525) {
                    this.isFacing = true;
                    bs = (class_2680)bs.method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11043);
                }
                if (p == class_2741.field_12545) {
                    this.isHopperFacing = true;
                    bs = (class_2680)bs.method_11657((class_2769)class_2741.field_12545, (Comparable)class_2350.field_11043);
                }
                if (p == class_2741.field_12481) {
                    this.isHorizontalFacing = true;
                    bs = (class_2680)bs.method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.field_11043);
                }
                if (p == class_2741.field_12496) {
                    this.isAxis = true;
                    bs = (class_2680)bs.method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11052);
                }
                if (p != class_2741.field_12529) continue;
                this.isHorizontalAxis = true;
                bs = (class_2680)bs.method_11657((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11052);
            }
            this.method_9590(bs);
        }
    }

    public boolean isLit() {
        return this.isLit;
    }

    public boolean method_9542(class_2680 state) {
        if (this.isLit) {
            return (Boolean)state.method_11654((class_2769)class_2741.field_12548);
        }
        return super.method_9542(state);
    }

    public void method_9606(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        this.interact(state, level, pos);
        super.method_9606(state, level, pos, player);
    }

    public void method_9591(class_1937 level, class_2338 pos, class_2680 state, class_1297 entity) {
        this.interact(state, level, pos);
        super.method_9591(level, pos, state, entity);
    }

    private void interact(class_2680 state, class_1937 level, class_2338 pos) {
        if (this.isLit && !((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!level.field_9236) {
            this.interact(state, level, pos);
        }
        if (this.isLit) {
            class_1799 itemStack = player.method_5998(hand);
            return itemStack.method_7909() instanceof class_1747 && new class_1750(player, hand, itemStack, hit).method_7716() ? class_1269.field_5811 : class_1269.field_5812;
        }
        return super.method_9534(state, level, pos, player, hand, hit);
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, Random random) {
        if (this.isLit && ((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false)), 3);
        }
        super.method_9514(state, level, pos, random);
    }

    public float method_36555() {
        if (this.target != null) {
            return this.target.method_36555();
        }
        return super.method_36555();
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, Random random) {
        if (this.target != null) {
            this.target.method_9496(state, level, pos, random);
        }
        if (this.stoneTarget != null) {
            this.stoneTarget.method_9496(state, level, pos, random);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        if (this.props != null) {
            if (this.props.length != 0) {
                builder.method_11667(this.props);
            }
        } else if (staticProps != null && staticProps.length != 0) {
            builder.method_11667(staticProps);
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        if (this.target != null) {
            state = this.target.method_9564();
            List items = this.target.method_9560(state, builder);
            return items.stream().map(x -> {
                if (x.method_31574(this.target.method_8389()) && this.method_8389() != class_1802.field_8162 && !ExcavatedVariants.getConfig().unobtainable_variants) {
                    int count = x.method_7947();
                    class_1799 out = new class_1799((class_1935)this.method_8389(), count);
                    return out;
                }
                return x;
            }).toList();
        }
        return new ArrayList<class_1799>();
    }

    public void method_9565(class_2680 state, class_3218 level, class_2338 pos, class_1799 stack) {
        class_2248 target = this.target;
        if (target != null) {
            target.method_9565(state, level, pos, stack);
        } else {
            super.method_9565(state, level, pos, stack);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 def = this.method_9564();
        if (this.isAxis) {
            def = (class_2680)def.method_11657((class_2769)class_2741.field_12496, (Comparable)context.method_8038().method_10166());
        } else if (this.isHorizontalAxis) {
            def = (class_2680)def.method_11657((class_2769)class_2741.field_12529, (Comparable)context.method_8042().method_10166());
        } else if (this.isFacing) {
            def = (class_2680)def.method_11657((class_2769)class_2741.field_12525, (Comparable)context.method_8038().method_10153());
        } else if (this.isHopperFacing) {
            class_2350 d = context.method_8038().method_10153();
            def = (class_2680)def.method_11657((class_2769)class_2741.field_12545, (Comparable)(d.method_10166() == class_2350.class_2351.field_11052 ? class_2350.field_11033 : d));
        } else if (this.isHorizontalFacing) {
            def = (class_2680)def.method_11657((class_2769)class_2741.field_12481, (Comparable)context.method_8042());
        }
        return def;
    }

    public boolean isAxisType() {
        return this.isAxis || this.isHorizontalAxis;
    }

    public boolean isFacingType() {
        return this.isFacing || this.isHorizontalFacing || this.isHopperFacing;
    }

    public class_2680 getStateForReplacement(class_2680 thisState) {
        if (this.isFacing && thisState.method_28498((class_2769)class_2741.field_12525)) {
            return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)((class_2350)thisState.method_11654((class_2769)class_2741.field_12525)));
        }
        if (this.isHorizontalFacing && thisState.method_28498((class_2769)class_2741.field_12481)) {
            return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)thisState.method_11654((class_2769)class_2741.field_12481)));
        }
        if (this.isHopperFacing && thisState.method_28498((class_2769)class_2741.field_12545)) {
            return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12545, (Comparable)((class_2350)thisState.method_11654((class_2769)class_2741.field_12545)));
        }
        if (this.isAxis && thisState.method_28498((class_2769)class_2741.field_12496)) {
            return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12496, (Comparable)((class_2350.class_2351)thisState.method_11654((class_2769)class_2741.field_12496)));
        }
        if (this.isHorizontalAxis && thisState.method_28498((class_2769)class_2741.field_12529)) {
            return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12529, (Comparable)((class_2350.class_2351)thisState.method_11654((class_2769)class_2741.field_12529)));
        }
        return this.method_9564();
    }
}

