/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.lukebemish.dynamic_asset_generator.Pair;
import io.github.lukebemish.dynamic_asset_generator.api.ResettingSupplier;
import io.github.lukebemish.dynamic_asset_generator.api.ServerPrePackRepository;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class MiningLevelTagGenerator {
    private final String level;
    private final ArrayList<CheckPair> toCheck = new ArrayList();
    HashSet<String> to_add;

    public MiningLevelTagGenerator(String level) {
        this.level = level;
    }

    public void add(String full_id, BaseOre ore) {
        this.toCheck.add(new CheckPair(full_id, ore.block_id.get(0).toString()));
    }

    public List<Pair<class_2960, Supplier<Boolean>>> suppliers() {
        ArrayList<Pair<class_2960, Supplier<Boolean>>> outList = new ArrayList<Pair<class_2960, Supplier<Boolean>>>();
        for (CheckPair c : this.toCheck) {
            outList.add((Pair<class_2960, Supplier<Boolean>>)new Pair((Object)new class_2960("excavated_variants", c.full_id()), this.supplyFor(c.full_id())));
        }
        return outList;
    }

    public ResettingSupplier<Boolean> supplyFor(final String full_id) {
        return new ResettingSupplier<Boolean>(){

            public void reset() {
                MiningLevelTagGenerator.this.reset();
            }

            public Boolean get() {
                MiningLevelTagGenerator.this.get();
                return MiningLevelTagGenerator.this.to_add.contains(full_id);
            }
        };
    }

    public void get() {
        if (this.to_add == null) {
            this.to_add = new HashSet();
            try {
                List read = ServerPrePackRepository.getResources((class_2960)new class_2960("minecraft", "tags/blocks/needs_" + this.level + "_tool.json"));
                for (InputStream is : read) {
                    StringBuilder textBuilder = new StringBuilder();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName(StandardCharsets.UTF_8.name())));
                    int c = 0;
                    while ((c = ((Reader)reader).read()) != -1) {
                        textBuilder.append((char)c);
                    }
                    String readStr = textBuilder.toString();
                    JsonElement parser = JsonParser.parseString((String)readStr);
                    if (parser.isJsonObject()) {
                        JsonElement replace = parser.getAsJsonObject().get("replace");
                        if (replace != null && replace.isJsonPrimitive() && replace.getAsJsonPrimitive().isBoolean() && replace.getAsBoolean()) {
                            this.to_add.clear();
                        }
                        JsonElement values = parser.getAsJsonObject().get("values");
                        ArrayList<String> entries = new ArrayList<String>();
                        if (values.isJsonArray()) {
                            for (JsonElement i : values.getAsJsonArray()) {
                                if (!i.isJsonPrimitive() || !i.getAsJsonPrimitive().isString()) continue;
                                String str = i.getAsJsonPrimitive().getAsString();
                                entries.addAll(this.parseTagEntry(str));
                            }
                        }
                        for (String str : entries) {
                            for (CheckPair j : this.toCheck) {
                                if (!j.base_id.equals(str)) continue;
                                this.to_add.add(j.full_id);
                            }
                        }
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                ExcavatedVariants.LOGGER.error("Could not load mining level tag for {}; will be empty...\n{}", (Object)this.level, (Object)e);
            }
        }
    }

    public List<String> parseTagEntry(String tagEntry) {
        if (!tagEntry.startsWith("#")) {
            return List.of(tagEntry);
        }
        class_2960 tagRL = class_2960.method_12838((String)tagEntry.substring(1), (char)':');
        ArrayList<String> entries = new ArrayList<String>();
        try {
            List read = ServerPrePackRepository.getResources((class_2960)new class_2960("minecraft", "tags/blocks/needs_" + this.level + "_tool.json"));
            for (InputStream is : read) {
                StringBuilder textBuilder = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charset.forName(StandardCharsets.UTF_8.name())));
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    textBuilder.append((char)c);
                }
                String readStr = textBuilder.toString();
                JsonElement parser = JsonParser.parseString((String)readStr);
                if (parser.isJsonObject()) {
                    JsonElement values;
                    JsonElement replace = parser.getAsJsonObject().get("replace");
                    if (replace != null && replace.isJsonPrimitive() && replace.getAsJsonPrimitive().isBoolean() && replace.getAsBoolean()) {
                        entries.clear();
                    }
                    if ((values = parser.getAsJsonObject().get("values")).isJsonArray()) {
                        for (JsonElement i : values.getAsJsonArray()) {
                            if (!i.isJsonPrimitive() || !i.getAsJsonPrimitive().isString()) continue;
                            String str = i.getAsJsonPrimitive().getAsString();
                            entries.add(str);
                        }
                    }
                }
                is.close();
            }
            return entries;
        }
        catch (IOException e) {
            ExcavatedVariants.LOGGER.warn("Could not load tag {}; ignoring...", (Object)tagEntry);
            return List.of();
        }
    }

    public void reset() {
        this.to_add = null;
    }

    private record CheckPair(String full_id, String base_id) {
    }
}

