/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants;

import io.github.lukebemish.dynamic_asset_generator.client.api.DynAssetGeneratorClientAPI;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.JsonHelper;
import io.github.lukebemish.excavated_variants.LangBuilder;
import io.github.lukebemish.excavated_variants.client.BlockStateAssembler;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import io.github.lukebemish.excavated_variants.data.ModData;
import io.github.lukebemish.excavated_variants.platform.Services;
import io.github.lukebemish.excavated_variants.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2960;

public class ExcavatedVariantsClient {
    public static void init() {
        LangBuilder langBuilder = new LangBuilder();
        Collection<String> modids = Services.PLATFORM.getModIds();
        HashMap<String, BaseStone> stoneMap = new HashMap<String, BaseStone>();
        HashMap<String, List> oreMap = new HashMap<String, List>();
        for (ModData mod : ExcavatedVariants.getConfig().mods) {
            if (!modids.containsAll(mod.mod_id)) continue;
            for (BaseStone stone : mod.provided_stones) {
                if (ExcavatedVariants.getConfig().blacklist_stones.contains(stone.id)) continue;
                stoneMap.put(stone.id, stone);
            }
            for (BaseOre ore : mod.provided_ores) {
                if (ExcavatedVariants.getConfig().blacklist_ores.contains(ore.id)) continue;
                oreMap.computeIfAbsent(ore.id, k -> new ArrayList());
                ((List)oreMap.get(ore.id)).add(ore);
            }
        }
        ArrayList<String> extractedOres = new ArrayList<String>();
        HashMap<String, Pair<BaseOre, BaseStone>> extractorMap = new HashMap<String, Pair<BaseOre, BaseStone>>();
        for (ModData mod : ExcavatedVariants.getConfig().mods) {
            if (!modids.containsAll(mod.mod_id)) continue;
            HashMap<String, BaseStone> internalStoneMap = new HashMap<String, BaseStone>();
            for (BaseStone stone : mod.provided_stones) {
                if (ExcavatedVariants.getConfig().blacklist_stones.contains(stone.id)) continue;
                internalStoneMap.put(stone.id, stone);
            }
            for (BaseOre ore : mod.provided_ores) {
                if (extractedOres.contains(ore.id)) continue;
                for (String stone_id : ore.stone) {
                    Pair<BaseOre, BaseStone> extractor;
                    if (internalStoneMap.get(stone_id) != null && extractorMap.get(ore.id) == null) {
                        extractor = new Pair<BaseOre, BaseStone>(ore, (BaseStone)internalStoneMap.get(stone_id));
                        extractorMap.put(ore.id, extractor);
                        continue;
                    }
                    if (stoneMap.get(stone_id) == null || extractorMap.get(ore.id) != null) continue;
                    extractor = new Pair<BaseOre, BaseStone>(ore, (BaseStone)stoneMap.get(stone_id));
                    extractorMap.put(ore.id, extractor);
                }
                extractedOres.add(ore.id);
            }
        }
        for (List oreList : oreMap.values()) {
            BaseOre ore = (BaseOre)oreList.get(0);
            for (String stone_id : ore.stone) {
                if (stoneMap.get(stone_id) == null || extractorMap.get(ore.id) != null) continue;
                Pair<BaseOre, BaseStone> extractor = new Pair<BaseOre, BaseStone>(ore, (BaseStone)stoneMap.get(stone_id));
                extractorMap.put(ore.id, extractor);
            }
        }
        ArrayList<Pair<BaseOre, BaseStone>> to_make = new ArrayList<Pair<BaseOre, BaseStone>>();
        ExcavatedVariants.setupMap();
        for (Pair<BaseOre, HashSet<BaseStone>> p : ExcavatedVariants.oreStoneList) {
            BaseOre ore = p.first();
            for (BaseStone stone : p.last()) {
                String full_id = stone.id + "_" + ore.id;
                to_make.add(new Pair<BaseOre, BaseStone>(ore, stone));
                DynAssetGeneratorClientAPI.planLoadingStream((class_2960)new class_2960("excavated_variants", "models/item/" + full_id + ".json"), JsonHelper.getItemModel(full_id));
                langBuilder.add(full_id, stone, ore);
            }
        }
        DynAssetGeneratorClientAPI.planLoadingStream((class_2960)new class_2960("excavated_variants", "lang/en_us.json"), langBuilder.build());
        BlockStateAssembler.setupClientAssets(extractorMap.values(), to_make);
    }
}

