/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants;

import io.github.lukebemish.dynamic_asset_generator.api.DynAssetGeneratorServerAPI;
import io.github.lukebemish.excavated_variants.MiningLevelTagGenerator;
import io.github.lukebemish.excavated_variants.ModifiedOreBlock;
import io.github.lukebemish.excavated_variants.api.IOreListModifier;
import io.github.lukebemish.excavated_variants.client.ClientServices;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import io.github.lukebemish.excavated_variants.data.ModConfig;
import io.github.lukebemish.excavated_variants.data.ModData;
import io.github.lukebemish.excavated_variants.platform.Services;
import io.github.lukebemish.excavated_variants.recipe.OreConversionRecipe;
import io.github.lukebemish.excavated_variants.util.Pair;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3111;
import net.minecraft.class_6796;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExcavatedVariants {
    public static final String MOD_ID = "excavated_variants";
    public static final Supplier<class_1865<OreConversionRecipe>> ORE_CONVERSION = Services.MAIN_PLATFORM_TARGET.get().registerRecipeSerializer("ore_conversion", () -> new class_1866(OreConversionRecipe::new));
    public static final Logger LOGGER = LogManager.getLogger((String)"excavated_variants");
    public static List<Pair<BaseOre, HashSet<BaseStone>>> oreStoneList;
    private static ModConfig configs;
    private static final List<Supplier<class_1792>> items;
    private static final Map<String, ModifiedOreBlock> blocks;
    private static final List<RegistryFuture> blockList;
    public static class_2975<class_3111, ?> ORE_REPLACER_CONFIGURED;
    public static class_6796 ORE_REPLACER_PLACED;
    private static boolean loaded;
    public static Set<class_2960> loadedBlockRLs;

    public static void init() {
        ExcavatedVariants.setupMap();
        ArrayList<class_2960> blockTagBuilder = new ArrayList<class_2960>();
        MiningLevelTagGenerator stoneTag = new MiningLevelTagGenerator("stone");
        MiningLevelTagGenerator ironTag = new MiningLevelTagGenerator("iron");
        MiningLevelTagGenerator diamondTag = new MiningLevelTagGenerator("diamond");
        ExcavatedVariants.setupMap();
        for (Pair<BaseOre, HashSet<BaseStone>> p : oreStoneList) {
            BaseOre ore = p.first();
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            for (BaseStone stone : p.last()) {
                String full_id = stone.id + "_" + ore.id;
                blockList.add(new RegistryFuture(full_id, ore, stone));
                if (ExcavatedVariants.getConfig().add_conversion_recipes) {
                    OreConversionRecipe.oreMap.put(new class_2960(MOD_ID, full_id), ore.block_id.get(0));
                }
                blockTagBuilder.add(new class_2960(MOD_ID, full_id));
                stoneTag.add(full_id, ore);
                ironTag.add(full_id, ore);
                diamondTag.add(full_id, ore);
                ids.add((CallSite)((Object)full_id));
            }
            for (String orename : ore.orename) {
                for (String string : ids) {
                    String oreTypeName = orename.substring(0, orename.length() - 4);
                    if (Services.PLATFORM.isFabriquilt()) {
                        DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("c", "items/" + orename + "s"), (class_2960)new class_2960(MOD_ID, string));
                        DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("c", "blocks/" + orename + "s"), (class_2960)new class_2960(MOD_ID, string));
                        DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("c", "items/ores/" + oreTypeName), (class_2960)new class_2960(MOD_ID, string));
                        DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("c", "blocks/ores/" + oreTypeName), (class_2960)new class_2960(MOD_ID, string));
                    } else if (orename.endsWith("_ore")) {
                        DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("forge", "items/ores/" + oreTypeName), (class_2960)new class_2960(MOD_ID, string));
                        DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("forge", "blocks/ores/" + oreTypeName), (class_2960)new class_2960(MOD_ID, string));
                    }
                    if (!Arrays.asList("iron_ore", "gold_ore", "coal_ore", "emerald_ore", "diamond_ore", "redstone_ore", "quartz_ore", "copper_ore", "netherite_scrap_ore").contains(orename)) continue;
                    DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("minecraft", "items/" + orename + "s"), (class_2960)new class_2960(MOD_ID, string));
                    DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("minecraft", "blocks/" + orename + "s"), (class_2960)new class_2960(MOD_ID, string));
                }
            }
        }
        DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("minecraft", "blocks/mineable/pickaxe"), blockTagBuilder);
        if (!Services.PLATFORM.isFabriquilt()) {
            DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("forge", "blocks/ores"), blockTagBuilder);
            DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("forge", "items/ores"), blockTagBuilder);
        } else {
            DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("c", "blocks/ores"), blockTagBuilder);
            DynAssetGeneratorServerAPI.planTagFile((class_2960)new class_2960("c", "items/ores"), blockTagBuilder);
        }
        DynAssetGeneratorServerAPI.planTagFileConditional((class_2960)new class_2960("minecraft", "blocks/needs_stone_tool"), stoneTag.suppliers());
        DynAssetGeneratorServerAPI.planTagFileConditional((class_2960)new class_2960("minecraft", "blocks/needs_iron_tool"), ironTag.suppliers());
        DynAssetGeneratorServerAPI.planTagFileConditional((class_2960)new class_2960("minecraft", "blocks/needs_diamond_tool"), diamondTag.suppliers());
        Services.MAIN_PLATFORM_TARGET.get().registerFeatures();
        loaded = true;
    }

    public static boolean setupMap() {
        if (oreStoneList == null || oreStoneList.size() == 0) {
            Collection<String> modids;
            try {
                modids = Services.PLATFORM.getModIds();
            }
            catch (NullPointerException e) {
                oreStoneList = new ArrayList<Pair<BaseOre, HashSet<BaseStone>>>();
                return false;
            }
            ExcavatedVariants.internalSetupMap(modids);
        }
        return true;
    }

    private static synchronized void internalSetupMap(Collection<String> modids) {
        oreStoneList = new ArrayList<Pair<BaseOre, HashSet<BaseStone>>>();
        HashMap<String, BaseStone> stoneMap = new HashMap<String, BaseStone>();
        HashMap<String, List> oreMap = new HashMap<String, List>();
        for (ModData mod : ExcavatedVariants.getConfig().mods) {
            if (!modids.containsAll(mod.mod_id)) continue;
            for (BaseStone stone : mod.provided_stones) {
                if (ExcavatedVariants.getConfig().blacklist_stones.contains(stone.id)) continue;
                stoneMap.put(stone.id, stone);
            }
            for (BaseOre ore : mod.provided_ores) {
                if (ExcavatedVariants.getConfig().blacklist_ores.contains(ore.id)) continue;
                oreMap.computeIfAbsent(ore.id, k -> new ArrayList());
                ((List)oreMap.get(ore.id)).add(ore);
            }
        }
        for (Object id : oreMap.keySet()) {
            List oreList = (List)oreMap.get(id);
            ArrayList<String> stones = new ArrayList<String>();
            for (Object ore : oreList) {
                stones.addAll(((BaseOre)ore).stone);
            }
            Pair pair = new Pair(((BaseOre)oreList.get(0)).clone(), new HashSet());
            if (oreList.size() > 1) {
                pair.first().block_id = new ArrayList<class_2960>();
                pair.first().orename = new ArrayList<String>();
                pair.first().stone = new ArrayList<String>();
                pair.first().types = new ArrayList<String>();
                for (BaseOre baseOre : oreList) {
                    pair.first().block_id.addAll(baseOre.block_id);
                    pair.first().orename.addAll(baseOre.orename);
                    pair.first().stone.addAll(baseOre.stone);
                    pair.first().types.addAll(baseOre.types);
                }
                List types = new HashSet<String>(pair.first().types).stream().toList();
                pair.first().types.clear();
                pair.first().types.addAll(types);
                List orenames = new HashSet<String>(pair.first().orename).stream().toList();
                pair.first().orename.clear();
                pair.first().orename.addAll(orenames);
            }
            oreStoneList.add(pair);
            for (BaseStone stone : stoneMap.values()) {
                String full_id;
                if (stones.contains(stone.id) || !oreList.stream().anyMatch(x -> x.types.stream().anyMatch(stone.types::contains)) || ExcavatedVariants.getConfig().blacklist_ids.contains(full_id = stone.id + "_" + (String)id)) continue;
                pair.last().add(stone);
            }
        }
        List<IOreListModifier> listListeners = Services.COMPAT.getOreListModifiers();
        for (IOreListModifier listListener : listListeners) {
            oreStoneList = listListener.modify(oreStoneList, stoneMap.values());
        }
        HashSet<String> done_ids = new HashSet<String>();
        ArrayList<Pair<BaseOre, HashSet<BaseStone>>> out = new ArrayList<Pair<BaseOre, HashSet<BaseStone>>>();
        for (Pair<BaseOre, HashSet<BaseStone>> p : oreStoneList) {
            Object ore;
            ore = p.first();
            if (done_ids.contains(((BaseOre)ore).id)) continue;
            done_ids.add(((BaseOre)ore).id);
            Pair o = new Pair((BaseOre)ore, new HashSet());
            out.add(o);
            for (BaseStone stone : p.last()) {
                String full_id = stone.id + "_" + ((BaseOre)ore).id;
                if (ExcavatedVariants.getConfig().blacklist_ids.contains(full_id)) continue;
                o.last().add(stone);
            }
        }
        oreStoneList = out;
    }

    public static ModConfig getConfig() {
        if (configs == null) {
            configs = ModConfig.get();
        }
        return configs;
    }

    public static Map<String, ModifiedOreBlock> getBlocks() {
        return blocks;
    }

    public static List<RegistryFuture> getBlockList() {
        return blockList;
    }

    public static void registerBlockAndItem(BiConsumer<class_2960, class_2248> blockRegistrar, BiFunction<class_2960, Supplier<class_1792>, Supplier<class_1792>> itemRegistrar, RegistryFuture future) {
        if (!future.done.booleanValue()) {
            future.done = true;
            String id = future.full_id;
            BaseOre o = future.ore;
            BaseStone s = future.stone;
            class_2960 rlToReg = new class_2960(MOD_ID, future.full_id);
            ModifiedOreBlock.setupStaticWrapper(o, s);
            ModifiedOreBlock b = Services.MAIN_PLATFORM_TARGET.get().makeDefaultOreBlock(o, s);
            blockRegistrar.accept(rlToReg, (class_2248)b);
            blocks.put(id, b);
            Supplier<class_1792> i = itemRegistrar.apply(rlToReg, () -> new class_1747((class_2248)b, new class_1792.class_1793().method_7892(Services.CREATIVE_TAB_LOADER.get().getCreativeTab())));
            items.add(i);
            ClientServices.RENDER_TYPE_HANDLER.setRenderTypeMipped((class_2248)b);
        }
    }

    public static List<Supplier<class_1792>> getItems() {
        return items;
    }

    public static boolean hasLoaded() {
        return loaded;
    }

    static {
        items = new ArrayList<Supplier<class_1792>>();
        blocks = new HashMap<String, ModifiedOreBlock>();
        blockList = new ArrayList<RegistryFuture>();
        loaded = false;
        loadedBlockRLs = new HashSet<class_2960>();
    }

    public static class RegistryFuture {
        public final BaseOre ore;
        public final BaseStone stone;
        public final String full_id;
        public Boolean done = false;

        public RegistryFuture(String s, BaseOre ore, BaseStone stone) {
            this.full_id = s;
            this.ore = ore;
            this.stone = stone;
        }
    }
}

