/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.dawn.mod.object.command;

import com.hugman.dawn.mod.util.data.BlockData;
import com.hugman.dawn.mod.util.data.DataList;
import com.hugman.dawn.mod.util.data.DataSerialization;
import com.hugman.dawn.mod.util.data.EnchantmentData;
import com.hugman.dawn.mod.util.data.EntityTypeData;
import com.hugman.dawn.mod.util.data.ItemData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2408;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_31;
import net.minecraft.class_3754;
import net.minecraft.class_5250;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import net.minecraft.class_5475;
import net.minecraft.class_6903;

public class ExportCommand {
    public static final int PERMISSION_LEVEL = 3;
    public static final String NAME = "export";
    public static final String REGISTRIES_ARG = "registries";
    public static final String EXPANDED_ARG = "expanded";
    public static final String WORLDGEN_ARG = "worldgen";
    public static final String BUILTIN_ARG = "builtin";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)NAME).requires(sc -> sc.method_9259(3))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)REGISTRIES_ARG).executes(cc -> ExportCommand.exportRegistries((class_2168)cc.getSource(), false))).then(class_2170.method_9244((String)EXPANDED_ARG, (ArgumentType)BoolArgumentType.bool()).executes(cc -> ExportCommand.exportRegistries((class_2168)cc.getSource(), BoolArgumentType.getBool((CommandContext)cc, (String)EXPANDED_ARG)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)WORLDGEN_ARG).executes(cc -> ExportCommand.exportWorldGen((class_2168)cc.getSource(), false))).then(class_2170.method_9244((String)BUILTIN_ARG, (ArgumentType)BoolArgumentType.bool()).executes(cc -> ExportCommand.exportWorldGen((class_2168)cc.getSource(), BoolArgumentType.getBool((CommandContext)cc, (String)BUILTIN_ARG))))));
    }

    public static int exportRegistries(class_2168 source, boolean expanded) {
        ArrayList registries = new ArrayList();
        registries.addAll(class_2378.field_11144.method_10220().toList());
        registries.addAll(class_5458.field_25926.method_10220().toList());
        source.method_9226((class_2561)new class_2588("commands.export.start"), true);
        try {
            for (class_2378 registry : registries) {
                ExportCommand.exportRegistry(registry, expanded);
            }
        }
        catch (IOException e) {
            source.method_9213((class_2561)new class_2588("commands.export.fail.unknown"));
            e.printStackTrace();
            return 0;
        }
        Path finalExportPath = Paths.get("debug", new String[0]).resolve(NAME).resolve("registry_entries");
        class_5250 exportFileComponent = new class_2585(finalExportPath.toString()).method_27695(new class_124[]{class_124.field_1078, class_124.field_1073}).method_27694(text -> text.method_10958(new class_2558(class_2558.class_2559.field_11746, finalExportPath.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2588("chat.fileExplorer.click"))));
        source.method_9226((class_2561)new class_2588("commands.export.success", new Object[]{exportFileComponent}), true);
        return 1;
    }

    public static <T> void exportRegistry(class_2378<T> registry, boolean expanded) throws IOException {
        String[] modIds;
        Path entriesPath = Paths.get("debug", new String[0]).resolve(NAME).resolve("registry_entries");
        for (String modId : modIds = (String[])registry.method_10235().stream().map(class_2960::method_12836).distinct().toArray(String[]::new)) {
            Path path = entriesPath.resolve(modId).resolve(registry.method_30517().method_29177().method_12836()).resolve(registry.method_30517().method_29177().method_12832() + ".json");
            Set entries = registry.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals(modId)).collect(Collectors.toSet());
            DataList<Object> dataList = null;
            if (expanded) {
                if (registry == class_2378.field_11146) {
                    dataList = new DataList<BlockData>(entries.stream().map(entry -> new BlockData(((class_5321)entry.getKey()).method_29177(), (class_2248)entry.getValue())).toList());
                } else if (registry == class_2378.field_11142) {
                    dataList = new DataList<ItemData>(entries.stream().map(entry -> new ItemData(((class_5321)entry.getKey()).method_29177(), (class_1792)entry.getValue())).toList());
                } else if (registry == class_2378.field_11160) {
                    dataList = new DataList<EnchantmentData>(entries.stream().map(entry -> new EnchantmentData(((class_5321)entry.getKey()).method_29177(), (class_1887)entry.getValue())).toList());
                } else if (registry == class_2378.field_11145) {
                    dataList = new DataList<EntityTypeData>(entries.stream().map(entry -> new EntityTypeData(((class_5321)entry.getKey()).method_29177(), (class_1299)entry.getValue())).toList());
                }
            }
            if (dataList == null) {
                dataList = new DataList<class_2960>(entries.stream().map(e -> ((class_5321)e.getKey()).method_29177()).toList());
            }
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            DataSerialization.saveToFile(path.toFile(), dataList.getClass(), dataList);
        }
    }

    public static int exportWorldGen(class_2168 source, boolean builtin) {
        if (!source.method_9211().method_3724() && source.method_9211().method_3788() > 1) {
            source.method_9213((class_2561)new class_2588("commands.export.worldgen.fail.multiplayer"));
            return 0;
        }
        Path finalExportPath = Paths.get("debug", new String[0]).resolve(NAME).resolve("world_gen");
        Path exportPath = finalExportPath.resolve("cache");
        class_5250 exportFileComponent = new class_2585(finalExportPath.toString()).method_27695(new class_124[]{class_124.field_1078, class_124.field_1073}).method_27694(text -> text.method_10958(new class_2558(class_2558.class_2559.field_11746, finalExportPath.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2588("chat.fileExplorer.click"))));
        if (exportPath.toFile().exists()) {
            source.method_9213((class_2561)new class_2588("commands.export.worldgen.fail.already_exists", new Object[]{exportFileComponent}));
            return 0;
        }
        source.method_9226((class_2561)new class_2588("commands.export.start"), true);
        try {
            class_2378 worldSettings;
            class_2408 cache = new class_2408(exportPath, "cache");
            class_5455.class_6893 registry = builtin ? class_5455.method_40314() : source.method_9225().method_30349();
            class_6903 ops = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)registry);
            class_5455.method_39674().forEach(arg_0 -> ExportCommand.lambda$exportWorldGen$14(cache, exportPath, (class_5455)registry, (DynamicOps)ops, arg_0));
            if (builtin) {
                class_2378 defaultDimensions = class_2874.method_28517((class_5455)registry, (long)0L, (boolean)false);
                class_3754 chunkGenerator = class_5285.method_39558((class_5455)registry, (long)0L, (boolean)false);
                worldSettings = class_5285.method_28608((class_2378)registry.method_33309(class_2378.field_25095), (class_2378)defaultDimensions, (class_2794)chunkGenerator);
            } else {
                worldSettings = ((class_31)source.method_9211().method_30002().method_8401()).method_28057().method_28609();
            }
            class_5475.method_39681((Path)exportPath, (class_2408)cache, (DynamicOps)ops, (class_5321)class_2378.field_25490, (class_2378)worldSettings, (Encoder)class_5363.field_25411);
            Path result = exportPath.resolve("reports").resolve(WORLDGEN_ARG);
            Files.walk(result, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    if (path.getFileName().toString().endsWith(".json")) {
                        String newTarget = result.relativize((Path)path).toString();
                        Path newPath = finalExportPath.resolve(newTarget);
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                        byte[] bytes = Files.readAllBytes(path);
                        Files.write(newPath, bytes, new OpenOption[0]);
                    }
                    Files.delete(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            Files.walk(exportPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            source.method_9226((class_2561)new class_2588("commands.export.success", new Object[]{exportFileComponent}), true);
            return 1;
        }
        catch (IOException e) {
            source.method_9213((class_2561)new class_2588("commands.export.fail.unknown"));
            e.printStackTrace();
            return 0;
        }
    }

    private static /* synthetic */ void lambda$exportWorldGen$14(class_2408 cache, Path exportPath, class_5455 registry, DynamicOps ops, class_5455.class_5456 info) {
        class_5475.method_39678((class_2408)cache, (Path)exportPath, (class_5455)registry, (DynamicOps)ops, (class_5455.class_5456)info);
    }
}

