/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.dawn.api.creator;

import com.hugman.dawn.api.creator.SimpleCreator;
import com.hugman.dawn.api.object.ModData;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;

public class BlockCreator
extends SimpleCreator<class_2248> {
    private final Builder builder;

    private BlockCreator(Builder builder) {
        super((class_2378<?>)class_2378.field_11146, builder.name, builder.provider.apply(builder.settings));
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    @Override
    public void register(ModData modData) {
        super.register(modData);
        if (!this.builder.noItem) {
            class_1747 blockItem = (class_1747)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)modData.id(this.builder.name), (Object)new class_1747((class_2248)this.value, new class_1792.class_1793().method_7892(this.builder.itemGroup)));
            blockItem.method_7713(class_1792.field_8003, (class_1792)blockItem);
        }
    }

    @Override
    public void postRegister(ModData modData) {
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)this.value, this.builder.flammabilityBurn, this.builder.flammabilitySpread);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientRegister(ModData modData) {
        class_1921 renderF;
        if (this.builder.render != null) {
            renderF = switch (this.builder.render) {
                default -> class_1921.method_23577();
                case Render.CUTOUT -> class_1921.method_23581();
                case Render.CUTOUT_MIPPED -> class_1921.method_23579();
                case Render.TRANSLUCENT -> class_1921.method_23583();
            };
        } else {
            renderF = class_1921.method_23577();
        }
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this.value, renderF);
    }

    @Override
    public void serverRegister(ModData modData, boolean isDedicatedServer) {
        if (!this.builder.noItem) {
            if (this.builder.cookTime != 0) {
                FuelRegistry.INSTANCE.add((class_1935)this.value, (Object)this.builder.cookTime);
            }
            if (this.builder.compostingChance != 0.0f) {
                CompostingChanceRegistry.INSTANCE.add((class_1935)this.value, (Object)Float.valueOf(this.builder.compostingChance));
            }
        }
    }

    public static class Builder {
        protected String name;
        protected Function<class_4970.class_2251, ? extends class_2248> provider;
        protected class_4970.class_2251 settings;
        protected Render render;
        protected class_1761 itemGroup;
        protected int flammabilityBurn;
        protected int flammabilitySpread;
        protected boolean noItem;
        protected int cookTime;
        protected float compostingChance;

        public Builder() {
        }

        protected Builder(String name, Function<class_4970.class_2251, ? extends class_2248> provider, class_4970.class_2251 settings, Render render, class_1761 itemGroup, int flammabilityBurn, int flammabilitySpread, boolean noItem, int cookTime, float compostingChance) {
            this.name = name;
            this.provider = provider;
            this.settings = settings;
            this.render = render;
            this.itemGroup = itemGroup;
            this.flammabilityBurn = flammabilityBurn;
            this.flammabilitySpread = flammabilitySpread;
            this.noItem = noItem;
            this.cookTime = cookTime;
            this.compostingChance = compostingChance;
        }

        public Builder(String name, Function<class_4970.class_2251, ? extends class_2248> provider, class_4970.class_2251 settings) {
            this.name = name;
            this.provider = provider;
            this.settings = settings;
        }

        @Deprecated
        public Builder(String prefix, Builder builder, class_4970.class_2251 settings) {
            this.name = prefix;
            this.from(builder);
            this.settings = settings;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder provider(Function<class_4970.class_2251, ? extends class_2248> provider) {
            this.provider = provider;
            return this;
        }

        public Builder settings(class_4970.class_2251 settings) {
            this.settings = settings;
            return this;
        }

        public Builder render(Render render) {
            this.render = render;
            return this;
        }

        public Builder itemGroup(class_1761 itemGroup) {
            this.itemGroup = itemGroup;
            return this;
        }

        public Builder flammability(int flammability) {
            this.flammabilityBurn = flammability;
            this.flammabilitySpread = flammability;
            return this;
        }

        public Builder flammability(int burn, int spread) {
            this.flammabilityBurn = burn;
            this.flammabilitySpread = spread;
            return this;
        }

        public Builder cookTime(int cookTime) {
            this.cookTime = cookTime;
            return this;
        }

        public Builder compostingChance(float compostingChance) {
            this.compostingChance = compostingChance;
            return this;
        }

        public Builder noItem() {
            this.noItem = true;
            return this;
        }

        public Builder from(Builder template) {
            this.name = template.name != null ? template.name : this.name;
            this.provider = template.provider != null ? template.provider : this.provider;
            this.settings = template.settings != null ? template.settings : this.settings;
            this.render = template.render != null ? template.render : this.render;
            this.itemGroup = template.itemGroup != null ? template.itemGroup : this.itemGroup;
            this.flammabilityBurn = template.flammabilityBurn != 0 ? template.flammabilityBurn : this.flammabilityBurn;
            this.flammabilitySpread = template.flammabilitySpread != 0 ? template.flammabilitySpread : this.flammabilitySpread;
            this.noItem = template.noItem || this.noItem;
            this.cookTime = template.cookTime != 0 ? template.cookTime : this.cookTime;
            this.compostingChance = template.compostingChance != 0.0f ? template.compostingChance : this.compostingChance;
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder applyTemplate(Builder template) {
            return this.from(template);
        }

        public BlockCreator build() {
            Objects.requireNonNull(this.name, "Cannot build a block with no name!");
            Objects.requireNonNull(this.provider, "Cannot build a block with no block provider!");
            Objects.requireNonNull(this.settings, "Cannot build a block with no block settings!");
            return new BlockCreator(this.copy());
        }

        public Builder copy() {
            return this.copy(this.name);
        }

        public Builder copy(String name) {
            return new Builder(name, this.provider, (class_4970.class_2251)(this.settings != null ? FabricBlockSettings.copyOf((class_4970.class_2251)this.settings) : null), this.render, this.itemGroup, this.flammabilityBurn, this.flammabilitySpread, this.noItem, this.cookTime, this.compostingChance);
        }
    }

    public static enum Render {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRANSLUCENT;

    }
}

