/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.Gobber2;
import com.kwpugh.gobber2.api.ArmorRemoveHandler;
import com.kwpugh.gobber2.api.ArmorTickable;
import com.kwpugh.gobber2.util.PlayerEquipUtil;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class DragonArmor
extends class_1738
implements ArmorRemoveHandler,
ArmorTickable {
    boolean enableDragonBreathing;
    boolean enableDragonFirePerk;
    boolean enableDragonHealthPerks;
    boolean enableDragonCuring;
    boolean enableDragonNoFallDamage;
    boolean unbreakableDragonArmor;
    int healingPointsDragonArmor;
    boolean enableFlying;

    public DragonArmor(class_1741 material, class_1304 slot, class_1792.class_1793 settings) {
        super(material, slot, settings);
        this.enableDragonBreathing = Gobber2.CONFIG.GENERAL.enableDragonBreathing;
        this.enableDragonFirePerk = Gobber2.CONFIG.GENERAL.enableDragonFirePerk;
        this.enableDragonHealthPerks = Gobber2.CONFIG.GENERAL.enableDragonHealthPerks;
        this.enableDragonCuring = Gobber2.CONFIG.GENERAL.enableDragonCuring;
        this.enableDragonNoFallDamage = Gobber2.CONFIG.GENERAL.enableDragonNoFallDamage;
        this.unbreakableDragonArmor = Gobber2.CONFIG.GENERAL.unbreakableDragonArmor;
        this.healingPointsDragonArmor = Gobber2.CONFIG.GENERAL.healingPointsDragonArmor;
        this.enableFlying = Gobber2.CONFIG.GENERAL.enableDragonFlying;
    }

    @Override
    public void tickArmor(class_1799 stack, class_1657 player) {
        class_1937 world = player.field_6002;
        if (PlayerEquipUtil.isWearingDragonArmor(player)) {
            if (this.enableDragonHealthPerks && player.field_6012 % 180 == 0) {
                PlayerSpecialAbilities.giveGreaterAbsorption(player);
                PlayerSpecialAbilities.giveSaturationEffect(player);
                PlayerSpecialAbilities.giveHealing(player, this.healingPointsDragonArmor);
            }
            if (this.enableDragonCuring) {
                PlayerSpecialAbilities.giveCuringEffect(world, player);
            }
            if (this.enableDragonNoFallDamage) {
                player.field_6017 = 0.0f;
            }
            if (this.enableFlying) {
                player.method_31549().field_7478 = true;
            }
        }
    }

    @Override
    public void onRemoved(class_1657 player) {
        if (!(!this.enableFlying || this.field_7880 != class_1304.field_6169 && this.field_7880 != class_1304.field_6174 && this.field_7880 != class_1304.field_6172 && this.field_7880 != class_1304.field_6166 || player.method_7337() || player.method_7325())) {
            player.method_31549().field_7478 = false;
            player.method_31549().field_7479 = false;
        }
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        if (this.unbreakableDragonArmor) {
            stack.method_7948().method_10556("Unbreakable", true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        if (this.enableDragonBreathing || this.enableDragonCuring || this.enableDragonFirePerk || this.enableDragonHealthPerks || this.enableDragonNoFallDamage) {
            tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip1").method_27692(class_124.field_1060));
        }
        if (this.enableDragonFirePerk) {
            tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip2").method_27692(class_124.field_1060));
        }
        if (this.enableDragonBreathing) {
            tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip3").method_27692(class_124.field_1060));
        }
        if (this.enableDragonCuring) {
            tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip4").method_27692(class_124.field_1060));
        }
        if (this.enableDragonHealthPerks) {
            tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip5").method_27692(class_124.field_1060));
        }
        if (this.enableDragonNoFallDamage) {
            tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip6").method_27692(class_124.field_1060));
        }
        if (this.enableFlying) {
            tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip7").method_27692(class_124.field_1060));
        }
    }
}

