/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="gobber2")
public class Gobber2Config
extends PartitioningSerializer.GlobalData {
    public Ores ORES = new Ores();
    public General GENERAL = new General();

    @Config(name="ores")
    public static class Ores
    implements ConfigData {
        @Comment(value="\n\n***********************\nNo worldgen options\n***********************")
        public boolean enableGobberAlternateDrops = false;
        public float diamondGobberDropChance = 0.15f;
        public float netherGoldGobberDropChance = 0.15f;
        @Comment(value="\n\n***********************\nLucky Block\n***********************")
        public int luckyVeinSize = 4;
        public int luckyMaxLevel = 120;
        public int luckyPerChunk = 15;
        @Comment(value="\n\n***********************\nLucky Block - Deepslate\n***********************")
        public int luckyDeepslateVeinSize = 4;
        public int luckyDeepslateMaxLevel = 0;
        public int luckyDeepslatePerChunk = 15;
        @Comment(value="\n\n***********************\nLucky Block - Nether\n***********************")
        public int luckyNetherVeinSize = 4;
        public int luckyNetherMaxLevel = 128;
        public int luckyNetherPerChunk = 15;
        @Comment(value="\n\n***********************\nLucky Block - Drops\n- only use values between .001 to .999\n- values cannot overlap\n- values should be in decending order from\ncutoff, common, uncommon, and rare\n- values above cutoff threshold get nothing\n***********************")
        public boolean enableExtraLoot = false;
        public boolean enableFortune = false;
        public double cutoffThreshold = 0.1;
        public double commonThreshold = 0.02;
        public double uncommonThreshold = 0.009;
        public double rareThreshold = 0.006;
        public String defaultDrop = "gobbers:gobber2_foo";
        @Comment(value="\n\n***********************\nGobber Ore\n***********************")
        public int gobberVeinSize = 4;
        public int gobberMaxLevel = 5;
        public int gobberPerChunk = 20;
        @Comment(value="\n\n***********************\nDeepslate Gobber Ore\n***********************")
        public int gobberDeepslateVeinSize = 4;
        public int gobberDeepslateMaxLevel = 0;
        public int gobberDeepslatePerChunk = 20;
        @Comment(value="\n\n***********************\nNether Gobber Ore\n***********************")
        public int netherGobberVeinSize = 4;
        public int netherGobberMaxLevel = 40;
        public int netherGobberPerChunk = 20;
        @Comment(value="\n\n***********************\nEnd Gobber Ore\n***********************")
        public int endGobberVeinSize = 9;
        public int endGobberMaxLevel = 180;
        public int endGobberPerChunk = 25;
    }

    @Config(name="general")
    public static class General
    implements ConfigData {
        @Comment(value="\n\n***********************\nRing Settings\n***********************")
        public int ringAboveCooldown = 120;
        public boolean enableAirWalkingPlaceGlass = true;
        public int ringAttractionRange = 8;
        public int ringBlinkDistance = 100;
        public int ringBlinkCooldown = 120;
        public boolean enableCuringAlwaysOn = false;
        public int ringCuringCooldown = 120;
        public double ringDismissalRange = 8.0;
        public double ringDismissalVelocity = 0.2;
        public double ringDismissalLift = 1.5;
        public int ringExplorerCooldown = 240;
        public boolean ringExplorerUsePlayerPos = false;
        public int ringExplorerMin = 5000;
        public int ringExplorerMax = 20000;
        public int ringFarmerHorizRange = 12;
        public int ringFarmerVertRange = 6;
        public int ringFarmerInterval = 60;
        public int ringFarmerIntervalCactus = 20;
        public int ringPhoenixHealAmount = 5;
        public int ringHasteLevel = 2;
        public int ringLuckLevel = 4;
        public int ringMinerCooldown = 120;
        public int ringMinerRange = 5;
        public int ringMinerVerticalRange = 4;
        public boolean ringMinerSharedBreaking = false;
        public boolean ringMinerSharedBreakingDelay = true;
        public boolean ringMinerInstantBreak = false;
        public int ringRepairInterval = 90;
        public int ringStrengthLevel = 2;
        public int ringStrengthResistenceLevel = 1;
        public int ringSwiftnessLevel = 1;
        public double ringTravelerLaunch = 4.0;
        public double ringTravelerCruising = 0.2;
        @Comment(value="\n\n***********************\nEffect Setting\n-used with optimization mods\nthat break things\nValue of 300 works\n- only needed if there is a problem\n***********************")
        public int effectDuration = 8;
        public int effectDurationKnowledge = 120;
        @Comment(value="\n\n***********************\nMedallion Settings\n***********************")
        public int medallionExpMultiplier = 5;
        public int medallionLesserHealingAmount = 1;
        public int medallionHealingAmount = 2;
        public int medallionGreaterHealingAmount = 3;
        public boolean medallionSeaAlwaysOn = false;
        public int medallionShieldingHorizRange = 3;
        public int medallionShieldingVertRange = 2;
        public boolean medallionShieldingAgainstWither = false;
        public int medallionSufferingRange = 6;
        public int medallionSufferingDamage = 2;
        @Comment(value="\n\n***********************\nStaff Settings\n***********************")
        public int staffTransformationDurability = 1025;
        public int staffClearingHorizRange = 6;
        public int staffClearingVertRange = 3;
        public int staffClearingCooldown = 120;
        public int staffSniperCooldown = 240;
        public boolean staffSniperQuickUseAllowed = true;
        public int staffFarmerHorizRange = 12;
        public int staffFarmerVertRange = 6;
        public int staffFarmerInterval = 60;
        public int staffFarmerIntervalCactus = 20;
        public boolean staffFarmerReplant = true;
        public boolean staffEnsnarementHotileMobs = false;
        @Comment(value="\n\n***********************\nTool Settings\n***********************")
        public int swordSniperCooldoown = 240;
        public boolean swordSniperQuickUseAllowed = true;
        public boolean enableEndHammer5x5 = true;
        public boolean enableEndExcavator5x5 = true;
        public boolean enableNetherSwordPerks = true;
        @Comment(value="\n\n\n******************************\nBow Durability\n******************************")
        public int gobberBowDurability = 3800;
        public int gobberNetherBowDurability = 5200;
        public int gobberEndBowDurability = 8000;
        @Comment(value="\n\n\n******************************\nGobber Tool Material Stats\n******************************")
        public int gobberDurability = 3800;
        public float gobberMiningSpeed = 9.0f;
        public float gobberAttackDamage = 9.0f;
        public float gobberSwordAttackSpeed = 2.0f;
        public int gobberMiningLevel = 4;
        public int gobberEnchantability = 20;
        @Comment(value="\n\n\n******************************\nGobber Nether Tool Material Stats\n******************************")
        public int gobberNetherDurability = 5200;
        public float gobberNetherMiningSpeed = 12.0f;
        public float gobberNetherAttackDamage = 9.0f;
        public float gobberNetherSwordAttackSpeed = 2.2f;
        public int gobberNetherMiningLevel = 5;
        public int gobberNetherEnchantability = 25;
        @Comment(value="\n\n\n******************************\nGobber End Tool Material Stats\n******************************")
        public boolean unbreakableEndTools = true;
        public int gobberEndDurability = 8000;
        public float gobberEndMiningSpeed = 14.0f;
        public float gobberEndAttackDamage = 9.0f;
        public float gobberEndSwordAttackSpeed = 2.4f;
        public int gobberEndMiningLevel = 5;
        public int gobberEndEnchantability = 30;
        @Comment(value="\n\n\n******************************\nGobber Armor Material Stats\n******************************")
        public int gobberDurabilityMultiplier = 71;
        public int gobberArmorEnchantability = 25;
        public float gobberToughness = 3.0f;
        public float gobberKnockbackResistance = 0.0f;
        public int gobberHeadProtection = 6;
        public int gobberChestProtection = 11;
        public int gobberLeggingsProtection = 9;
        public int gobberBootsProtection = 6;
        @Comment(value="\n\n\n******************************\nGobber Nether Armor Material Stats\n******************************")
        public int gobberNetherDurabilityMultiplier = 83;
        public int gobberNetherArmorEnchantability = 30;
        public float gobberNetherToughness = 3.25f;
        public float gobberNetherKnockbackResistance = 0.1f;
        public int netherHeadProtection = 7;
        public int netherChestProtection = 12;
        public int netherLeggingsProtection = 10;
        public int netherBootsProtection = 7;
        @Comment(value="\n\n\n******************************\nGobber End Armor Material Stats\n******************************")
        public int gobberEndDurabilityMultiplier = 100;
        public int gobberEndArmorEnchantability = 30;
        public float gobberEndToughness = 3.5f;
        public float gobberEndKnockbackResistance = 0.2f;
        public int endHeadProtection = 8;
        public int endChestProtection = 13;
        public int endLeggingsProtection = 11;
        public int endBootsProtection = 8;
        @Comment(value="\n\n\n******************************\nDragon Armor Material Stats\n******************************")
        public int gobberDragonDurabilityMultiplier = 100;
        public int gobberDragonArmorEnchantability = 30;
        public float gobberDragonToughness = 3.75f;
        public float gobberDragonKnockbackResistance = 0.3f;
        public int dragonHeadProtection = 8;
        public int dragonChestProtecction = 13;
        public int dragonLeggingsProtection = 11;
        public int dragonBootsProtection = 8;
        @Comment(value="\n\n***********************\nGobber Armor Features\n***********************")
        public boolean enableGobberBreathing = true;
        public boolean enableGobberHealthPerks = true;
        public int healingPointsGobberArmor = 2;
        @Comment(value="\n\n***********************\nNether Armor Features\n***********************")
        public boolean enableNetherFirePerk = true;
        public boolean enableNetherHealthPerks = true;
        public int healingPointsNetherArmor = 2;
        @Comment(value="\n\n***********************\nEnd Armor Features\n***********************")
        public boolean unbreakableEndArmor = true;
        public boolean enableEndBreathing = true;
        public boolean enableEndFirePerk = true;
        public boolean enableEndHealthPerks = true;
        public int healingPointsEndArmor = 3;
        public boolean enableEndNoFallDamage = true;
        public boolean enableGlidingEndArmor = true;
        @Comment(value="\n\n***********************\nDragon Armor Features\n***********************")
        public boolean unbreakableDragonArmor = true;
        public boolean enableDragonBreathing = true;
        public boolean enableDragonFirePerk = true;
        public boolean enableDragonHealthPerks = true;
        public int healingPointsDragonArmor = 4;
        public boolean enableDragonCuring = true;
        public boolean enableDragonNoFallDamage = true;
        public boolean enableGlidingDragonArmor = true;
        public boolean enableDragonFlying = true;
        @Comment(value="\n\n***********************\nEnchantments\n***********************")
        public boolean enableSummonerBonusStats = true;
        public boolean summonerGoldGear = true;
        public int summonerMobLifespan = 120;
        @Comment(value="\n\n***********************\nEnchantment Settings\n***********************")
        public int smithbladeAttackAmount = 2;
        public int smithbladeMaxLevel = 5;
        public int rebuffingMaxLevel = 3;
        public int untouchableDamage = 8;
        public int untouchableMaxLevel = 3;
        public double summonerHealthBonus = 30.0;
        public double summonerAttackBonus = 10.0;
        public double summonerMovementBonus = 0.6;
        public double summonerArmorBonus = 20.0;
        public boolean summonerEventEnable = true;
        public boolean enableRingEnchanting = true;
        public boolean enableStaffEnchanting = true;
        public boolean enableMedallionEnchanting = true;
        public boolean apotropaicEventEnable = true;
        @Comment(value="\n\n***********************\nStatus Effects\n***********************")
        public int KnowledgeBoostXPPerTick = 1;
        @Comment(value="\n\n***********************\nLoot Chests\n***********************")
        public boolean lootEnable = true;
        public float lootChance = 0.04f;
        @Comment(value="\n\n***********************\nSpecial Item\n\nItem provides a one-time random teleport\nand is consumed after successful teleport.\nMin/Max range from world spawn to search\nor from the player's current position\nItem does NOT have a standard recipe\n***********************")
        public boolean enableSpecialItem = true;
        public int specialItemMin = 20000;
        public int specialItemMax = 75000;
        public boolean specialItemUsePlayerPos = false;
        @Comment(value="\n\n***********************\nFuel (Foo) Settings\n\n***********************")
        public int fooBurntime = 12000;
        public int fooNetherBurntime = 24000;
        public int fooEndBurntime = 32000;
        @Comment(value="\n\n\n******************************\nBow Zoom Multiplier\n- vanilla bow value = .15F\n- pretty good value = .45F\n- awesome value = .75F\n******************************")
        public float bowZoomMultiplier = 0.45f;
    }
}

