/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.tags;

import io.github.lukebemish.dynamic_asset_generator.Pair;
import io.github.lukebemish.dynamic_asset_generator.api.ResettingSupplier;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class TagBuilder {
    private final List<Pair<class_2960, Supplier<Boolean>>> paths = new ArrayList<Pair<class_2960, Supplier<Boolean>>>();

    public void add(Pair<class_2960, Supplier<Boolean>> p) {
        this.paths.add(p);
    }

    public ResettingSupplier<InputStream> supply() {
        return new ResettingSupplier<InputStream>(){

            @Override
            public void reset() {
                for (Pair<class_2960, Supplier<Boolean>> p : TagBuilder.this.paths) {
                    Supplier<Boolean> supplier = p.last();
                    if (!(supplier instanceof ResettingSupplier)) continue;
                    ResettingSupplier rs = (ResettingSupplier)supplier;
                    rs.reset();
                }
            }

            @Override
            public InputStream get() {
                return TagBuilder.this.build();
            }
        };
    }

    private InputStream build() {
        StringBuilder internal = new StringBuilder();
        for (Pair<class_2960, Supplier<Boolean>> p : this.paths) {
            if (!p.last().get().booleanValue()) continue;
            class_2960 rl = p.first();
            if (internal.length() >= 1) {
                internal.append(",");
            }
            internal.append("\"").append(rl.method_12836()).append(":").append(rl.method_12832()).append("\"");
        }
        String json = "{\"replace\":false,\"values\":[" + internal + "]}";
        return new ByteArrayInputStream(json.getBytes());
    }
}

