/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.lukebemish.dynamic_asset_generator.datagen.ImageSource;
import io.github.lukebemish.dynamic_asset_generator.datagen.TextureConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;

public abstract class TextureConfigProvider
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2403 generator;
    private final String modid;
    private final Map<class_2960, TextureConfig> generatedConfigs = new HashMap<class_2960, TextureConfig>();

    public TextureConfigProvider(class_2403 generator, String modid) {
        this.generator = generator;
        this.modid = modid;
    }

    public abstract void addConfigs();

    public final TextureConfig config(String path) {
        return this.generatedConfigs.computeIfAbsent(new class_2960(this.modid, path), loc -> new TextureConfig());
    }

    public final ImageSource.File fileSource(class_2960 texture) {
        return new ImageSource.File(this, texture);
    }

    public final ImageSource.Fallback fallbackSource() {
        return new ImageSource.Fallback(this);
    }

    public final ImageSource.Color colorSource() {
        return new ImageSource.Color(this);
    }

    public final ImageSource.Overlay overlaySource() {
        return new ImageSource.Overlay(this);
    }

    public final ImageSource.Mask maskSource() {
        return new ImageSource.Mask(this);
    }

    public final ImageSource.Crop cropSource() {
        return new ImageSource.Crop(this);
    }

    public final ImageSource.Transform transformSource() {
        return new ImageSource.Transform(this);
    }

    public final ImageSource.CombinedPalettedImage combinedPalettedImageSource() {
        return new ImageSource.CombinedPalettedImage(this);
    }

    public final ImageSource.ForegroundTransfer foregroundTransferSource() {
        return new ImageSource.ForegroundTransfer(this);
    }

    protected boolean checkTextureExists(class_2960 texture) {
        return true;
    }

    public final void method_10319(class_2408 cache) {
        this.generatedConfigs.clear();
        this.addConfigs();
        this.writeConfigs(cache);
    }

    private void writeConfigs(class_2408 cache) {
        for (class_2960 location : this.generatedConfigs.keySet()) {
            Path target = this.generator.method_10313().resolve(String.format("assets/%s/dynamic_assets_sources/%s.json", location.method_12836(), location.method_12832()));
            try {
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)this.generatedConfigs.get(location).toJson(), (Path)target);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String method_10321() {
        return "Texture Configs";
    }
}

