/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.util;

import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.api.ResettingSupplier;
import io.github.lukebemish.dynamic_asset_generator.client.palette.Palette;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_2960;

public interface IPalettePlan {
    public class_1011 getBackground() throws IOException;

    public class_1011 getOverlay() throws IOException;

    public class_1011 getPaletted() throws IOException;

    public boolean includeBackground();

    public boolean stretchPaletted();

    public int extend();

    default public ResettingSupplier<InputStream> getStream(class_2960 rl) {
        return ResettingSupplier.of(() -> {
            try (class_1011 image = Palette.paletteCombinedImage(this);){
                if (image == null) return null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.method_24036());
                return byteArrayInputStream;
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not write buffered image to stream: {}...\n", (Object)rl, (Object)e);
            }
            return null;
        }, this);
    }

    public static ResettingSupplier<InputStream> supply(class_2960 rl, Supplier<IPalettePlan> plan_sup) {
        return ResettingSupplier.of(() -> {
            IPalettePlan planned = (IPalettePlan)plan_sup.get();
            try (class_1011 image = Palette.paletteCombinedImage(planned);){
                if (image == null) return null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.method_24036());
                return byteArrayInputStream;
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not write buffered image to stream: {}...\n", (Object)rl, (Object)e);
            }
            return null;
        }, plan_sup);
    }
}

