/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.client.util.SafeImageExtraction;
import java.util.function.Supplier;
import net.minecraft.class_1011;

public class Transform
implements ITexSource {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public Supplier<class_1011> getSupplier(String inputStr) throws JsonSyntaxException {
        LocationSource locationSource = (LocationSource)gson.fromJson(inputStr, LocationSource.class);
        Supplier<class_1011> input = DynamicTextureJson.readSupplierFromSource(locationSource.input);
        return () -> {
            if (input == null) {
                DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...");
                return null;
            }
            class_1011 inImg = (class_1011)input.get();
            if (inImg == null) {
                DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...\n{}", (Object)locationSource.input.toString());
                return null;
            }
            class_1011 output = inImg;
            for (int i = 0; i < locationSource.rotate; ++i) {
                output = Transform.clockwiseRotate(output);
            }
            if (locationSource.flip) {
                class_1011 output2 = NativeImageHelper.of(output.method_4318(), output.method_4307(), output.method_4323(), false);
                for (int x = 0; x < output.method_4307(); ++x) {
                    for (int y = 0; y < output.method_4323(); ++y) {
                        output2.method_4305(output.method_4307() - 1 - x, y, SafeImageExtraction.get(output, x, y));
                    }
                }
                output.close();
                output = output2;
            }
            return output;
        };
    }

    private static class_1011 clockwiseRotate(class_1011 input) {
        int w = input.method_4307();
        int h = input.method_4323();
        class_1011 output = NativeImageHelper.of(input.method_4318(), h, w, false);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                output.method_4305(y, w - x - 1, SafeImageExtraction.get(input, x, y));
            }
        }
        input.close();
        return output;
    }

    public static class LocationSource {
        @Expose
        String source_type;
        @Expose
        int rotate;
        @Expose
        boolean flip;
        @Expose
        public JsonObject input;
    }
}

