/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.client.util.SafeImageExtraction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1011;

public class Overlay
implements ITexSource {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public Supplier<class_1011> getSupplier(String inputStr) throws JsonSyntaxException {
        LocationSource locationSource = (LocationSource)gson.fromJson(inputStr, LocationSource.class);
        ArrayList<Supplier<class_1011>> inputs = new ArrayList<Supplier<class_1011>>();
        for (JsonObject o : locationSource.inputs) {
            inputs.add(DynamicTextureJson.readSupplierFromSource(o));
        }
        return () -> {
            int maxX = 0;
            int maxY = 0;
            List<class_1011> images = inputs.stream().map(Supplier::get).toList();
            for (int i = 0; i < images.size(); ++i) {
                if (images.get(i) != null) continue;
                DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...\n{}", (Object)locationSource.inputs.get(i).toString());
                return null;
            }
            for (class_1011 image : images) {
                if (image.method_4307() <= maxX) continue;
                maxX = image.method_4307();
                maxY = image.method_4323();
            }
            try (MultiCloser multiCloser = new MultiCloser(images);){
                class_1011 output = NativeImageHelper.of(class_1011.class_1012.field_4997, maxX, maxY, false);
                class_1011 base = images.get(0);
                int xs = 1;
                int ys = 1;
                if ((double)base.method_4307() / ((double)base.method_4323() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                    xs = maxX / base.method_4307();
                    ys = maxY / base.method_4307();
                } else {
                    xs = maxX / base.method_4323();
                    ys = maxY / base.method_4323();
                }
                for (int x = 0; x < maxX; ++x) {
                    for (int y = 0; y < maxY; ++y) {
                        output.method_4305(x, y, SafeImageExtraction.get(base, x / xs, y / ys));
                    }
                }
                if (images.size() >= 2) {
                    for (int i = 1; i < images.size(); ++i) {
                        class_1011 image = images.get(i);
                        if ((double)image.method_4307() / ((double)image.method_4323() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                            xs = maxX / image.method_4307();
                            ys = maxY / image.method_4307();
                        } else {
                            xs = maxX / image.method_4323();
                            ys = maxY / image.method_4323();
                        }
                        for (int x = 0; x < maxX; ++x) {
                            for (int y = 0; y < maxY; ++y) {
                                ColorHolder input = ColorHolder.fromColorInt(SafeImageExtraction.get(output, x, y));
                                ColorHolder top = ColorHolder.fromColorInt(SafeImageExtraction.get(image, x / xs, y / ys));
                                ColorHolder outColor = ColorHolder.alphaBlend(top, input);
                                output.method_4305(x, y, ColorHolder.toColorInt(outColor));
                            }
                        }
                    }
                }
                class_1011 class_10112 = output;
                return class_10112;
            }
        };
    }

    public static class LocationSource {
        @Expose
        String source_type;
        @Expose
        public List<JsonObject> inputs;
    }

    public static class MultiCloser
    implements AutoCloseable {
        private final List<? extends AutoCloseable> toClose;

        public MultiCloser(List<? extends AutoCloseable> toClose) {
            this.toClose = toClose;
        }

        @Override
        public void close() {
            for (AutoCloseable autoCloseable : this.toClose) {
                try {
                    autoCloseable.close();
                }
                catch (Exception e) {
                    DynamicAssetGenerator.LOGGER.error("Exception while closing resources:\n", (Throwable)e);
                }
            }
        }
    }
}

