/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.client.util.SafeImageExtraction;
import java.util.function.Supplier;
import net.minecraft.class_1011;

public class Mask
implements ITexSource {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public Supplier<class_1011> getSupplier(String inputStr) throws JsonSyntaxException {
        LocationSource locationSource = (LocationSource)gson.fromJson(inputStr, LocationSource.class);
        Supplier<class_1011> input = DynamicTextureJson.readSupplierFromSource(locationSource.input);
        Supplier<class_1011> mask = DynamicTextureJson.readSupplierFromSource(locationSource.mask);
        return () -> {
            if (input == null || mask == null) {
                DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...");
                return null;
            }
            try (class_1011 inImg = (class_1011)input.get();){
                class_1011 class_10112;
                block27: {
                    class_1011 maskImg;
                    block25: {
                        class_1011 class_10113;
                        block26: {
                            block23: {
                                class_1011 class_10114;
                                block24: {
                                    maskImg = (class_1011)mask.get();
                                    if (maskImg != null) break block23;
                                    DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...\n{}", (Object)locationSource.mask.toString());
                                    class_10114 = null;
                                    if (maskImg == null) break block24;
                                    maskImg.close();
                                }
                                return class_10114;
                            }
                            if (inImg != null) break block25;
                            DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...\n{}", (Object)locationSource.input.toString());
                            class_10113 = null;
                            if (maskImg == null) break block26;
                            maskImg.close();
                        }
                        return class_10113;
                    }
                    try {
                        int iys;
                        int ixs;
                        int mys;
                        int mxs;
                        int maxY;
                        int maxX = Math.max(inImg.method_4307(), maskImg.method_4307());
                        int n = maxY = inImg.method_4307() > maskImg.method_4307() ? inImg.method_4323() : maskImg.method_4323();
                        if ((double)maskImg.method_4307() / ((double)maskImg.method_4323() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                            mxs = maxX / maskImg.method_4307();
                            mys = maxY / maskImg.method_4307();
                        } else {
                            mxs = maxX / maskImg.method_4323();
                            mys = maxY / maskImg.method_4323();
                        }
                        if ((double)inImg.method_4307() / ((double)inImg.method_4323() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                            ixs = inImg.method_4307() / maxX;
                            iys = inImg.method_4307() / maxY;
                        } else {
                            ixs = inImg.method_4323() / maxX;
                            iys = inImg.method_4323() / maxY;
                        }
                        class_1011 out = NativeImageHelper.of(class_1011.class_1012.field_4997, maxX, maxY, false);
                        for (int x = 0; x < maxX; ++x) {
                            for (int y = 0; y < maxY; ++y) {
                                ColorHolder mC = ColorHolder.fromColorInt(SafeImageExtraction.get(maskImg, x / mxs, y / mys));
                                ColorHolder iC = ColorHolder.fromColorInt(SafeImageExtraction.get(inImg, x / ixs, y / iys));
                                ColorHolder o = iC.withA(mC.getA() * iC.getA());
                                out.method_4305(x, y, ColorHolder.toColorInt(o));
                            }
                        }
                        class_10112 = out;
                        if (maskImg == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (maskImg != null) {
                            try {
                                maskImg.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    maskImg.close();
                }
                return class_10112;
            }
        };
    }

    public static class LocationSource {
        @Expose
        String source_type;
        @Expose
        public JsonObject input;
        @Expose
        public JsonObject mask;
    }
}

