/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import java.util.function.Supplier;
import net.minecraft.class_1011;

public class FallbackSource
implements ITexSource {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public Supplier<class_1011> getSupplier(String inputStr) throws JsonSyntaxException {
        LocationSource locationSource = (LocationSource)gson.fromJson(inputStr, LocationSource.class);
        Supplier<class_1011> original = DynamicTextureJson.readSupplierFromSource(locationSource.original);
        Supplier<class_1011> fallback = DynamicTextureJson.readSupplierFromSource(locationSource.fallback);
        return () -> {
            class_1011 img;
            if (original != null) {
                img = (class_1011)original.get();
                if (img != null) {
                    return img;
                }
                DynamicAssetGenerator.LOGGER.debug("Issue loading main texture, trying fallback");
            }
            if (fallback != null && (img = (class_1011)fallback.get()) != null) {
                return img;
            }
            DynamicAssetGenerator.LOGGER.warn("Texture given was nonexistent...");
            return null;
        };
    }

    public static class LocationSource {
        @Expose
        String source_type;
        @Expose
        public JsonObject original;
        @Expose
        public JsonObject fallback;
    }
}

