/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.client.palette.Palette;
import io.github.lukebemish.dynamic_asset_generator.client.util.IPalettePlan;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.class_1011;

public class CombinedPaletteImage
implements ITexSource {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public Supplier<class_1011> getSupplier(String inputStr) throws JsonSyntaxException {
        PaletteInfo info = (PaletteInfo)gson.fromJson(inputStr, PaletteInfo.class);
        PalettePlanner planner = PalettePlanner.of(info);
        if (planner == null) {
            return null;
        }
        return () -> Palette.paletteCombinedImage(planner);
    }

    public static class PaletteInfo {
        @Expose
        String source_type;
        @Expose
        public JsonObject overlay;
        @Expose
        public JsonObject background;
        @Expose
        public JsonObject paletted;
        @Expose
        public boolean include_background;
        @Expose
        public boolean stretch_paletted;
        @Expose
        public int extend_palette_size;
    }

    public static class PalettePlanner
    implements IPalettePlan {
        private final PaletteInfo info;
        private Supplier<class_1011> overlay;
        private Supplier<class_1011> background;
        private Supplier<class_1011> paletted;

        private PalettePlanner(PaletteInfo info) {
            this.info = info;
        }

        public static PalettePlanner of(PaletteInfo info) {
            PalettePlanner out = new PalettePlanner(info);
            out.background = DynamicTextureJson.readSupplierFromSource(info.background);
            out.paletted = DynamicTextureJson.readSupplierFromSource(info.paletted);
            out.overlay = DynamicTextureJson.readSupplierFromSource(info.overlay);
            if (out.overlay == null || out.background == null || out.paletted == null) {
                return null;
            }
            return out;
        }

        @Override
        public class_1011 getBackground() throws IOException {
            return this.background.get();
        }

        @Override
        public class_1011 getOverlay() throws IOException {
            return this.overlay.get();
        }

        @Override
        public class_1011 getPaletted() throws IOException {
            return this.paletted.get();
        }

        @Override
        public boolean includeBackground() {
            return this.info.include_background;
        }

        @Override
        public boolean stretchPaletted() {
            return this.info.stretch_paletted;
        }

        @Override
        public int extend() {
            return this.info.extend_palette_size;
        }
    }
}

