/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.api.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DynamicTextureJson {
    private static final Map<class_2960, ITexSource> sources = new HashMap<class_2960, ITexSource>();
    private static final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    @Expose
    public String output_location;
    @Expose
    public JsonObject input;
    public Supplier<class_1011> source;

    @Nullable
    public static DynamicTextureJson fromJson(String json) throws JsonSyntaxException {
        DynamicTextureJson out = (DynamicTextureJson)gson.fromJson(json, DynamicTextureJson.class);
        if (out.input != null && out.output_location != null) {
            Supplier<class_1011> buffer = DynamicTextureJson.readSupplierFromSource(out.input);
            if (buffer == null) {
                return null;
            }
            out.source = buffer;
        } else {
            DynamicAssetGenerator.LOGGER.error("Could not load JSON: {}", (Object)json);
        }
        return out;
    }

    public static Supplier<class_1011> readSupplierFromSource(JsonObject obj) throws JsonSyntaxException {
        if (obj.has("source_type") && obj.get("source_type").isJsonPrimitive() && obj.get("source_type").getAsJsonPrimitive().isString()) {
            String type = obj.get("source_type").getAsString();
            class_2960 input_type = class_2960.method_12838((String)type, (char)':');
            ITexSource source = sources.getOrDefault(input_type, null);
            if (source == null) {
                DynamicAssetGenerator.LOGGER.error("Unrecognized texture source type: " + type);
                return null;
            }
            Supplier<class_1011> buffer = source.getSupplier(obj.toString());
            if (buffer == null) {
                DynamicAssetGenerator.LOGGER.error("Bad input for source type: " + type);
                return null;
            }
            return buffer;
        }
        DynamicAssetGenerator.LOGGER.error("No valid source type found!");
        return null;
    }

    public static void registerTexSourceReadingType(class_2960 rl, ITexSource reader) {
        sources.put(rl, reader);
    }
}

