/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.api;

import com.google.common.collect.ImmutableList;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.mixin.IPackRepositoryMixin;
import io.github.lukebemish.dynamic_asset_generator.platform.Services;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;

public class ClientPrePackRepository {
    private static List<? extends class_3262> resources = new ArrayList<class_3262>();
    public static final String SOURCE_JSON_DIR = "dynamic_assets_sources";

    public static void resetResources() {
        resources = null;
    }

    private static List<? extends class_3262> getResources() {
        if (resources == null || resources.size() == 0) {
            resources = Services.DEGROUPER.unpackPacks((List)((IPackRepositoryMixin)class_310.method_1551().method_1520()).getSelected().stream().filter(p -> !p.method_14463().contains("dynamic_asset_generator:client") && !p.method_14463().contains("dynamic_asset_generator:data")).map(class_3288::method_14458).filter(p -> !p.method_14409().contains("dynamic_asset_generator:client") && !p.method_14409().contains("dynamic_asset_generator:data")).collect(ImmutableList.toImmutableList()));
        }
        return resources;
    }

    public static InputStream getResource(class_2960 rl) throws IOException {
        InputStream resource = null;
        for (class_3262 class_32622 : ClientPrePackRepository.getResources()) {
            if (class_32622.method_14409().equals("dynamic_asset_generator:client") || !class_32622.method_14411(class_3264.field_14188, rl)) continue;
            if (resource != null) {
                resource.close();
            }
            resource = class_32622.method_14405(class_3264.field_14188, rl);
        }
        if (resource != null) {
            return resource;
        }
        throw new IOException("Could not find resource in pre-load: " + rl.toString());
    }

    public static HashMap<class_2960, String> getSourceJsons() {
        HashMap<class_2960, String> rls = new HashMap<class_2960, String>();
        HashSet<class_2960> available = new HashSet<class_2960>();
        for (class_3262 class_32622 : ClientPrePackRepository.getResources()) {
            if (class_32622.method_14409().equals("dynamic_asset_generator:client") || class_32622.method_14409().equals("dynamic_asset_generator:data")) continue;
            for (String namespace : class_32622.method_14406(class_3264.field_14188)) {
                for (class_2960 rl : class_32622.method_14408(class_3264.field_14188, namespace, SOURCE_JSON_DIR, 6, x -> x.endsWith(".json"))) {
                    if (!class_32622.method_14411(class_3264.field_14188, rl)) continue;
                    available.add(rl);
                }
            }
        }
        for (class_2960 class_29602 : available) {
            try {
                InputStream resource = ClientPrePackRepository.getResource(class_29602);
                try {
                    String text = new String(resource.readAllBytes(), StandardCharsets.UTF_8);
                    rls.put(class_29602, text);
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Issues loading texture source jsons...");
            }
        }
        return rls;
    }
}

