/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client;

import com.google.gson.JsonSyntaxException;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.ModConfig;
import io.github.lukebemish.dynamic_asset_generator.WrappedSupplier;
import io.github.lukebemish.dynamic_asset_generator.api.ResettingSupplier;
import io.github.lukebemish.dynamic_asset_generator.client.api.ClientPrePackRepository;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.util.IPalettePlan;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_2960;

public class DynAssetGenClientPlanner {
    private static final Map<class_2960, Supplier<InputStream>> miscResources = new HashMap<class_2960, Supplier<InputStream>>();
    private static final List<Supplier<Map<class_2960, Supplier<InputStream>>>> unresolved = new ArrayList<Supplier<Map<class_2960, Supplier<InputStream>>>>();

    public static void planPaletteCombinedImage(class_2960 rl, IPalettePlan image) {
        DynAssetGenClientPlanner.planPaletteCombinedImage(rl, () -> image);
    }

    public static void planPaletteCombinedImage(class_2960 rl, Supplier<IPalettePlan> plan_sup) {
        miscResources.put(rl, IPalettePlan.supply(rl, plan_sup));
    }

    public static void planNativeImage(class_2960 rl, Supplier<class_1011> supplier) {
        Supplier<InputStream> s = () -> {
            try (class_1011 image = (class_1011)supplier.get();){
                if (image == null) return null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.method_24036());
                return byteArrayInputStream;
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not write buffered image to stream: {}...\n", (Object)rl, (Object)e);
            }
            return null;
        };
        miscResources.put(rl, ResettingSupplier.of(s, supplier));
    }

    public static Map<class_2960, Supplier<InputStream>> getResources() {
        HashMap<class_2960, Supplier<InputStream>> output = new HashMap<class_2960, Supplier<InputStream>>(miscResources);
        for (Supplier<Map<class_2960, Supplier<InputStream>>> l : unresolved) {
            output.putAll(l.get());
        }
        HashMap<class_2960, String> sources = ClientPrePackRepository.getSourceJsons();
        for (class_2960 rl : sources.keySet()) {
            DynamicTextureJson source;
            String s = sources.get(rl);
            if (s == null || (source = DynamicTextureJson.fromJson(s)) == null) continue;
            class_2960 orig_rl = class_2960.method_12838((String)source.output_location, (char)':');
            class_2960 out_rl = new class_2960(orig_rl.method_12836(), "textures/" + orig_rl.method_12832() + ".png");
            Supplier<InputStream> sup = () -> {
                try (class_1011 image = source.source.get();){
                    if (image == null) return null;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.method_24036());
                    return byteArrayInputStream;
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Could not write buffered image to stream: " + out_rl.toString());
                    return null;
                }
                catch (JsonSyntaxException e) {
                    DynamicAssetGenerator.LOGGER.error("Issue loading texture source JSON: " + rl.toString());
                }
                return null;
            };
            output.put(out_rl, sup);
        }
        for (class_2960 rl : output.keySet()) {
            Supplier d = (Supplier)output.get(rl);
            if (d instanceof ResettingSupplier) {
                ResettingSupplier rs = (ResettingSupplier)d;
                rs.reset();
            }
            if (!DynamicAssetGenerator.getConfig().cacheAssets || d instanceof WrappedSupplier) continue;
            WrappedSupplier<InputStream> supplier = new WrappedSupplier<InputStream>(() -> DynAssetGenClientPlanner.lambda$getResources$3((Supplier)d, rl));
            output.put(rl, supplier);
        }
        return output;
    }

    public static void planLoadingStream(class_2960 location, Supplier<InputStream> sup) {
        if (DynamicAssetGenerator.getConfig().cacheAssets) {
            try {
                if (!Files.exists(ModConfig.ASSET_CACHE_FOLDER, new LinkOption[0])) {
                    Files.createDirectories(ModConfig.ASSET_CACHE_FOLDER, new FileAttribute[0]);
                }
                if (Files.exists(ModConfig.ASSET_CACHE_FOLDER.resolve(location.method_12836()).resolve(location.method_12832()), new LinkOption[0])) {
                    miscResources.put(location, () -> {
                        try {
                            File file = ModConfig.ASSET_CACHE_FOLDER.resolve(location.method_12836()).resolve(location.method_12832()).toFile();
                            if (file.isFile()) {
                                return new BufferedInputStream(new FileInputStream(file));
                            }
                        }
                        catch (IOException e) {
                            DynamicAssetGenerator.LOGGER.error("Issue with cached asset...", (Throwable)e);
                        }
                        return null;
                    });
                    return;
                }
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not cache asset...", (Throwable)e);
            }
        }
        miscResources.put(location, sup);
    }

    public static void planLoaders(Supplier<Map<class_2960, Supplier<InputStream>>> suppliers) {
        unresolved.add(() -> {
            Map map = (Map)suppliers.get();
            HashMap<class_2960, Supplier> out = new HashMap<class_2960, Supplier>();
            for (class_2960 location : map.keySet()) {
                if (DynamicAssetGenerator.getConfig().cacheData) {
                    try {
                        if (!Files.exists(ModConfig.DATA_CACHE_FOLDER, new LinkOption[0])) {
                            Files.createDirectories(ModConfig.DATA_CACHE_FOLDER, new FileAttribute[0]);
                        }
                        if (Files.exists(ModConfig.DATA_CACHE_FOLDER.resolve(location.method_12836()).resolve(location.method_12832()), new LinkOption[0])) {
                            out.put(location, () -> {
                                try {
                                    File file = ModConfig.DATA_CACHE_FOLDER.resolve(location.method_12836()).resolve(location.method_12832()).toFile();
                                    if (file.isFile()) {
                                        return new BufferedInputStream(new FileInputStream(file));
                                    }
                                }
                                catch (IOException e) {
                                    DynamicAssetGenerator.LOGGER.error("Could not load cached data...", (Throwable)e);
                                }
                                return null;
                            });
                            continue;
                        }
                    }
                    catch (IOException e) {
                        DynamicAssetGenerator.LOGGER.error("Could not cache data...", (Throwable)e);
                    }
                }
                out.put(location, (Supplier)map.get(location));
            }
            return out;
        });
    }

    private static /* synthetic */ InputStream lambda$getResources$3(Supplier d, class_2960 rl) {
        InputStream stream = (InputStream)d.get();
        if (stream != null) {
            try {
                Path path = ModConfig.ASSET_CACHE_FOLDER.resolve(rl.method_12836()).resolve(rl.method_12832());
                if (!Files.exists(path.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
                }
                return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not save asset...", (Throwable)e);
            }
        }
        return stream;
    }
}

