/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator;

import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.ModConfig;
import io.github.lukebemish.dynamic_asset_generator.WrappedSupplier;
import io.github.lukebemish.dynamic_asset_generator.api.ResettingSupplier;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class DynAssetGenServerPlanner {
    private static Map<class_2960, Supplier<InputStream>> data = new HashMap<class_2960, Supplier<InputStream>>();
    private static final List<Supplier<Map<class_2960, Supplier<InputStream>>>> unresolved = new ArrayList<Supplier<Map<class_2960, Supplier<InputStream>>>>();

    public static Map<class_2960, Supplier<InputStream>> getResources() {
        HashMap<class_2960, Supplier<InputStream>> outMap = new HashMap<class_2960, Supplier<InputStream>>(data);
        for (Supplier<Map<class_2960, Supplier<InputStream>>> l : unresolved) {
            if (l instanceof ResettingSupplier) {
                ResettingSupplier r = (ResettingSupplier)l;
                r.reset();
            }
            outMap.putAll(l.get());
        }
        for (class_2960 rl : outMap.keySet()) {
            Supplier<InputStream> d = outMap.get(rl);
            if (d instanceof ResettingSupplier) {
                ((ResettingSupplier)d).reset();
            }
            if (!DynamicAssetGenerator.getConfig().cacheData || d instanceof WrappedSupplier) continue;
            WrappedSupplier<InputStream> supplier = new WrappedSupplier<InputStream>(() -> {
                InputStream stream = (InputStream)d.get();
                if (stream != null) {
                    try {
                        Path path = ModConfig.DATA_CACHE_FOLDER.resolve(rl.method_12836()).resolve(rl.method_12832());
                        if (!Files.exists(path.getParent(), new LinkOption[0])) {
                            Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        }
                        if (!Files.exists(path, new LinkOption[0])) {
                            Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
                        }
                        return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
                    }
                    catch (IOException e) {
                        DynamicAssetGenerator.LOGGER.error("Could not save data...", (Throwable)e);
                    }
                }
                return stream;
            });
            outMap.put(rl, supplier);
        }
        return outMap;
    }

    public static void planLoadingStream(class_2960 location, Supplier<InputStream> sup) {
        if (DynamicAssetGenerator.getConfig().cacheData) {
            try {
                if (!Files.exists(ModConfig.DATA_CACHE_FOLDER, new LinkOption[0])) {
                    Files.createDirectories(ModConfig.DATA_CACHE_FOLDER, new FileAttribute[0]);
                }
                if (Files.exists(ModConfig.DATA_CACHE_FOLDER.resolve(location.method_12836()).resolve(location.method_12832()), new LinkOption[0])) {
                    data.put(location, () -> {
                        try {
                            File file = ModConfig.DATA_CACHE_FOLDER.resolve(location.method_12836()).resolve(location.method_12832()).toFile();
                            if (file.isFile()) {
                                return new BufferedInputStream(new FileInputStream(file));
                            }
                        }
                        catch (IOException e) {
                            DynamicAssetGenerator.LOGGER.error("Could not load cached data...", (Throwable)e);
                        }
                        return null;
                    });
                    return;
                }
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not cache data...", (Throwable)e);
            }
        }
        data.put(location, sup);
    }

    public static void planLoaders(Supplier<Map<class_2960, Supplier<InputStream>>> suppliers) {
        unresolved.add(() -> {
            Map map = (Map)suppliers.get();
            HashMap<class_2960, Supplier> out = new HashMap<class_2960, Supplier>();
            for (class_2960 location : map.keySet()) {
                if (DynamicAssetGenerator.getConfig().cacheData) {
                    try {
                        if (!Files.exists(ModConfig.DATA_CACHE_FOLDER, new LinkOption[0])) {
                            Files.createDirectories(ModConfig.DATA_CACHE_FOLDER, new FileAttribute[0]);
                        }
                        if (Files.exists(ModConfig.DATA_CACHE_FOLDER.resolve(location.method_12836()).resolve(location.method_12832()), new LinkOption[0])) {
                            out.put(location, () -> {
                                try {
                                    File file = ModConfig.DATA_CACHE_FOLDER.resolve(location.method_12836()).resolve(location.method_12832()).toFile();
                                    if (file.isFile()) {
                                        return new BufferedInputStream(new FileInputStream(file));
                                    }
                                }
                                catch (IOException e) {
                                    DynamicAssetGenerator.LOGGER.error("Could not load cached data...", (Throwable)e);
                                }
                                return null;
                            });
                            continue;
                        }
                    }
                    catch (IOException e) {
                        DynamicAssetGenerator.LOGGER.error("Could not cache data...", (Throwable)e);
                    }
                }
                out.put(location, (Supplier)map.get(location));
            }
            return out;
        });
    }
}

