/*
 * Decompiled with CFR 0.152.
 */
package nourl.mythicmetals.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;

public class FieldIterator {
    public static <C, F> void iterateAccessibleFields(C object, Class<F> targetFieldType, BiConsumer<F, String> fieldConsumer) {
        for (Field field : object.getClass().getDeclaredFields()) {
            Object value;
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (!targetFieldType.isAssignableFrom(value.getClass())) continue;
            String fieldId = field.getName().toLowerCase();
            fieldConsumer.accept(value, fieldId);
        }
    }
}

