/*
 * Decompiled with CFR 0.152.
 */
package nourl.mythicmetals.registry;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import nourl.mythicmetals.MythicMetals;
import nourl.mythicmetals.config.MythicConfig;
import nourl.mythicmetals.config.OreConfig;
import nourl.mythicmetals.utils.FieldIterator;

public final class MythicCommands {
    private MythicCommands() {
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccessdedicated) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"mythicmetals").then(class_2170.method_9247((String)"range").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::dumpType).requires(source -> source.method_9259(1))).executes(context -> {
            MythicConfig config = MythicMetals.CONFIG;
            if (config == null) {
                return 1;
            }
            switch (StringArgumentType.getString((CommandContext)context, (String)"type")) {
                case "console": {
                    FieldIterator.iterateAccessibleFields(config, OreConfig.class, (feature, name) -> {
                        if (feature.enabled && !feature.offset && !feature.trapezoid) {
                            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(name.toUpperCase(Locale.ROOT) + " has the range between " + feature.bottom + " to " + feature.top + ", with a discard chance of " + feature.discardChance * 100.0f + "%"), false);
                        }
                        if (feature.enabled && feature.offset) {
                            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(name.toUpperCase(Locale.ROOT) + " has the range between " + feature.bottom + "(offset) to " + feature.top + ", with a discard chance of " + feature.discardChance * 100.0f + "%"), false);
                        }
                        if (feature.enabled && feature.trapezoid) {
                            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(name.toUpperCase(Locale.ROOT) + " has a triangle range between " + feature.bottom + " to " + feature.top + ", where the sweet spot is at Y = " + (feature.bottom + feature.top) / 2 + " with a discard chance of " + feature.discardChance * 100.0f + "%"), false);
                        }
                        if (!feature.enabled) {
                            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585("Ore" + name + "is disabled."), false);
                        }
                    });
                    return 1;
                }
                case "file": {
                    int n;
                    OutputStream file = Files.newOutputStream(FabricLoader.getInstance().getConfigDir().resolve("debug/mythicmetals.csv"), new OpenOption[0]);
                    try {
                        StringBuilder contents = new StringBuilder();
                        FieldIterator.iterateAccessibleFields(config, OreConfig.class, (feature, name) -> {
                            if (feature.enabled) {
                                contents.append((String)name).append(",").append(feature.bottom).append(",").append(feature.top).append(",").append(feature.perChunk).append(",").append(feature.veinSize).append(",").append(feature.offset).append(",").append(feature.trapezoid).append("\n");
                            }
                        });
                        new OutputStreamWriter(file).write(contents.toString());
                        n = 1;
                        if (file == null) return n;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (file == null) throw throwable;
                            try {
                                file.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    file.close();
                    return n;
                }
            }
            return 1;
        })))));
    }

    private static CompletableFuture<Suggestions> dumpType(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        suggestion.suggest("console").suggest("file");
        return suggestion.buildFuture();
    }
}

