/*
 * Decompiled with CFR 0.152.
 */
package nourl.mythicmetals.abilities;

import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import nourl.mythicmetals.armor.ArmorSet;
import nourl.mythicmetals.tools.MidasGoldSword;
import nourl.mythicmetals.tools.MythicTools;
import nourl.mythicmetals.tools.ToolSet;

public class Ability {
    private final String tooltip;
    private final int level;
    private final Set<class_1792> items;
    private boolean showLevel = true;

    public Ability(String translationKey, int level) {
        this.tooltip = translationKey;
        this.level = level;
        this.items = new HashSet<class_1792>();
    }

    public Ability(String tranlsationKey, int level, boolean showLevel) {
        this.tooltip = tranlsationKey;
        this.level = level;
        this.items = new HashSet<class_1792>();
        this.showLevel = showLevel;
    }

    public int getLevel() {
        return this.level;
    }

    public Set<class_1792> getItems() {
        return this.items;
    }

    public void addItem(class_1792 item, class_2583 style) {
        this.items.add(item);
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            this.addTooltip(item, style);
        }
    }

    public void addArmorSet(ArmorSet armorSet, class_2583 style) {
        this.items.add((class_1792)armorSet.getHelmet());
        this.items.add((class_1792)armorSet.getChestplate());
        this.items.add((class_1792)armorSet.getLeggings());
        this.items.add((class_1792)armorSet.getBoots());
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            this.addTooltip((class_1792)armorSet.getHelmet(), style);
            this.addTooltip((class_1792)armorSet.getChestplate(), style);
            this.addTooltip((class_1792)armorSet.getLeggings(), style);
            this.addTooltip((class_1792)armorSet.getBoots(), style);
        }
    }

    public void addToolSet(ToolSet toolSet, class_2583 style) {
        this.items.add((class_1792)toolSet.getSword());
        this.items.add((class_1792)toolSet.getAxe());
        this.items.add((class_1792)toolSet.getHoe());
        this.items.add((class_1792)toolSet.getPickaxe());
        this.items.add((class_1792)toolSet.getShovel());
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT)) {
            this.addTooltip((class_1792)toolSet.getSword(), style);
            this.addTooltip((class_1792)toolSet.getAxe(), style);
            this.addTooltip((class_1792)toolSet.getHoe(), style);
            this.addTooltip((class_1792)toolSet.getPickaxe(), style);
            this.addTooltip((class_1792)toolSet.getShovel(), style);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void addTooltip(class_1792 item, class_2583 style) {
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
            class_2585 text = new class_2585("");
            if (stack.method_7909().equals(item)) {
                text.method_10852((class_2561)new class_2588("abilities.mythicmetals." + this.tooltip));
                text.method_10862(style);
                if (this.showLevel) {
                    text.method_27693(" ").method_10852((class_2561)new class_2588("enchantment.level." + this.level));
                }
                if (lines.size() > 2) {
                    int enchantCount = stack.method_7921().size();
                    lines.add(enchantCount + 1, text);
                } else {
                    lines.add(text);
                }
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void initMidasGoldTooltip() {
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
            if (stack.method_7909().equals(MythicTools.MIDAS_GOLD_SWORD) || stack.method_7909().equals(MythicTools.GILDED_MIDAS_GOLD_SWORD)) {
                int goldCount;
                int lineIndex = 1;
                if (lines.size() > 2) {
                    int enchantCount = stack.method_7921().size();
                    lineIndex = enchantCount + 1;
                }
                if ((goldCount = ((Integer)stack.get(MidasGoldSword.GOLD_FOLDED)).intValue()) < 64) {
                    lines.add(lineIndex, new class_2588("tooltip.midas_gold.level.0").method_27692(class_124.field_1065));
                    lines.add(lineIndex + 1, new class_2585(goldCount + " / 64").method_27692(class_124.field_1065));
                }
                if (goldCount >= 64 && goldCount < 128) {
                    lines.add(lineIndex, new class_2588("tooltip.midas_gold.level.1").method_27692(class_124.field_1065));
                    lines.add(lineIndex + 1, new class_2585(goldCount + " / 128").method_27692(class_124.field_1065));
                }
                if (goldCount >= 128 && goldCount < 192) {
                    lines.add(lineIndex, new class_2588("tooltip.midas_gold.level.2").method_27692(class_124.field_1065));
                    lines.add(lineIndex + 1, new class_2585(goldCount + " / 192").method_27692(class_124.field_1065));
                }
                if (goldCount >= 192 && goldCount < 256) {
                    lines.add(lineIndex, new class_2588("tooltip.midas_gold.level.3").method_27692(class_124.field_1065));
                    lines.add(lineIndex + 1, new class_2585(goldCount + " / 256").method_27692(class_124.field_1065));
                }
                if (goldCount >= 256 && goldCount < 320) {
                    lines.add(lineIndex, new class_2588("tooltip.midas_gold.level.4").method_27692(class_124.field_1065));
                    lines.add(lineIndex + 1, new class_2585(goldCount + " / 320").method_27692(class_124.field_1065));
                }
                if (goldCount >= 320 && goldCount < 640) {
                    lines.add(lineIndex, new class_2588("tooltip.midas_gold.level.5").method_27692(class_124.field_1065));
                    lines.add(lineIndex + 1, new class_2585(goldCount + " / 320").method_27692(class_124.field_1065));
                }
                if (goldCount >= 640) {
                    lines.add(lineIndex, new class_2588("tooltip.midas_gold.level.99").method_27692(class_124.field_1065));
                    lines.add(lineIndex + 1, new class_2585(goldCount + " / 640").method_27692(class_124.field_1065));
                }
            }
        });
    }
}

