/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class FertilizedEssenceItem
extends BaseItem {
    public FertilizedEssenceItem(Function<Item.Properties, Item.Properties> properties) {
        super(properties);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new DispenserBehavior());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        Direction direction = context.m_43719_();
        if (player == null || !player.m_36204_(pos.m_142300_(direction), direction, stack)) {
            return InteractionResult.FAIL;
        }
        if (FertilizedEssenceItem.applyFertilizer(stack, level, pos, player)) {
            if (!level.m_5776_()) {
                level.m_46796_(1505, pos, 0);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        int chance = (int)((Double)ModConfigs.FERTILIZED_ESSENCE_DROP_CHANCE.get() * 100.0);
        tooltip.add((Component)ModTooltips.FERTILIZED_ESSENCE_CHANCE.args(new Object[]{chance + "%"}).build());
    }

    public static boolean applyFertilizer(ItemStack stack, Level level, BlockPos pos, Player player) {
        BonemealableBlock growable;
        int hook;
        BlockState state = level.m_8055_(pos);
        if (player != null && (hook = ForgeEventFactory.onApplyBonemeal((Player)player, (Level)level, (BlockPos)pos, (BlockState)state, (ItemStack)stack)) != 0) {
            return hook > 0;
        }
        Block block = state.m_60734_();
        if (block instanceof BonemealableBlock && (growable = (BonemealableBlock)block).m_7370_((BlockGetter)level, pos, state, level.m_5776_())) {
            if (!level.m_5776_()) {
                Random random = level.m_5822_();
                if (growable.m_5491_(level, random, pos, state) || FertilizedEssenceItem.canGrowResourceCrops(growable)) {
                    growable.m_7719_((ServerLevel)level, random, pos, state);
                }
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    private static boolean canGrowResourceCrops(BonemealableBlock growable) {
        ICropProvider cropGetter;
        return growable instanceof ICropProvider && (cropGetter = (ICropProvider)growable).getCrop().getTier().isFertilizable();
    }

    public static class DispenserBehavior
    extends OptionalDispenseItemBehavior {
        protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
            this.m_123573_(true);
            ServerLevel level = source.m_7727_();
            BlockPos pos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            if (FertilizedEssenceItem.applyFertilizer(stack, (Level)level, pos, null)) {
                if (!level.m_5776_()) {
                    level.m_46796_(2005, pos, 0);
                }
            } else {
                this.m_123573_(false);
            }
            return stack;
        }
    }
}

