/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.mysticalagriculture.api.crafting.ISoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SoulExtractionRecipe
implements ISpecialRecipe,
ISoulExtractionRecipe {
    private final ResourceLocation recipeId;
    private final NonNullList<Ingredient> inputs;
    private final MobSoulType type;
    private final double souls;
    private final ItemStack output;

    public SoulExtractionRecipe(ResourceLocation recipeId, Ingredient input, MobSoulType type, double souls) {
        this.recipeId = recipeId;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{input});
        this.type = type;
        this.souls = souls;
        this.output = MobSoulUtils.getSoulJar(type, souls, (Item)ModItems.SOUL_JAR.get());
    }

    public ItemStack assemble(IItemHandler inventory) {
        ItemStack stack = inventory.getStackInSlot(2);
        ItemStack jar = StackHelper.withSize((ItemStack)stack, (int)1, (boolean)false);
        MobSoulUtils.addSoulsToJar(jar, this.type, this.souls);
        return jar;
    }

    public ItemStack m_5874_(Container inv) {
        return this.assemble((IItemHandler)new InvWrapper(inv));
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<SoulExtractionRecipe> m_7707_() {
        return ModRecipeSerializers.SOUL_EXTRACTION;
    }

    public RecipeType<? extends ISoulExtractionRecipe> m_6671_() {
        return RecipeTypes.SOUL_EXTRACTION;
    }

    public boolean matches(IItemHandler inventory, int startIndex, int endIndex) {
        ItemStack input = inventory.getStackInSlot(0);
        if (!((Ingredient)this.inputs.get(0)).test(input)) {
            return false;
        }
        ItemStack output = inventory.getStackInSlot(2);
        if (!output.m_41656_(this.output)) {
            return false;
        }
        return MobSoulUtils.canAddTypeToJar(output, this.type) && !MobSoulUtils.isJarFull(output);
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    public MobSoulType getMobSoulType() {
        return this.type;
    }

    @Override
    public double getSouls() {
        return this.souls;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<SoulExtractionRecipe> {
        public SoulExtractionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject ingredient = json.getAsJsonObject("input");
            Ingredient input = Ingredient.m_43917_((JsonElement)ingredient);
            JsonObject output = GsonHelper.m_13930_((JsonObject)json, (String)"output");
            String type = GsonHelper.m_13906_((JsonObject)output, (String)"type");
            float amount = GsonHelper.m_13915_((JsonObject)output, (String)"souls");
            MobSoulType mobSoulType = MobSoulTypeRegistry.getInstance().getMobSoulTypeById(new ResourceLocation(type));
            if (mobSoulType == null) {
                throw new JsonParseException("Invalid mob soul type id: " + type);
            }
            return new SoulExtractionRecipe(recipeId, input, mobSoulType, amount);
        }

        public SoulExtractionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ResourceLocation type = buffer.m_130281_();
            double souls = buffer.readDouble();
            MobSoulType mobSoulType = MobSoulTypeRegistry.getInstance().getMobSoulTypeById(type);
            return new SoulExtractionRecipe(recipeId, input, mobSoulType, souls);
        }

        public void toNetwork(FriendlyByteBuf buffer, SoulExtractionRecipe recipe) {
            ((Ingredient)recipe.inputs.get(0)).m_43923_(buffer);
            buffer.m_130085_(recipe.type.getId());
            buffer.writeDouble(recipe.souls);
        }
    }
}

