/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.jei;

import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.client.screen.ReprocessorScreen;
import com.blakebr0.mysticalagriculture.client.screen.SoulExtractorScreen;
import com.blakebr0.mysticalagriculture.compat.jei.CruxRecipe;
import com.blakebr0.mysticalagriculture.compat.jei.category.CruxCategory;
import com.blakebr0.mysticalagriculture.compat.jei.category.InfusionCategory;
import com.blakebr0.mysticalagriculture.compat.jei.category.ReprocessorCategory;
import com.blakebr0.mysticalagriculture.compat.jei.category.SoulExtractorCategory;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.blakebr0.mysticalagriculture.init.ModItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public final class JeiCompat
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("mysticalagriculture", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new InfusionCategory(guiHelper), new ReprocessorCategory(guiHelper), new SoulExtractorCategory(guiHelper), new CruxCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INFUSION_ALTAR.get()), new ResourceLocation[]{InfusionCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INFUSION_PEDESTAL.get()), new ResourceLocation[]{InfusionCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BASIC_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INFERIUM_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PRUDENTIUM_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.TERTIUM_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.IMPERIUM_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SUPREMIUM_REPROCESSOR.get()), new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SOUL_EXTRACTOR.get()), new ResourceLocation[]{SoulExtractorCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            RecipeManager manager = world.m_7465_();
            registration.addRecipes(manager.m_44054_(RecipeTypes.INFUSION).values(), InfusionCategory.UID);
            registration.addRecipes(manager.m_44054_(RecipeTypes.REPROCESSOR).values(), ReprocessorCategory.UID);
            registration.addRecipes(manager.m_44054_(RecipeTypes.SOUL_EXTRACTION).values(), SoulExtractorCategory.UID);
            registration.addRecipes(CruxRecipe.getGeneratedRecipes(), CruxCategory.UID);
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ReprocessorScreen.class, 99, 52, 22, 15, new ResourceLocation[]{ReprocessorCategory.UID});
        registration.addRecipeClickArea(SoulExtractorScreen.class, 99, 52, 22, 15, new ResourceLocation[]{SoulExtractorCategory.UID});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        ModItems.SOUL_JAR.ifPresent(jar -> registration.registerSubtypeInterpreter(jar, (stack, context) -> {
            MobSoulType type = MobSoulUtils.getType(stack);
            return type != null ? type.getEntityIds().toString() : "";
        }));
    }
}

