/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.worldgen;

import io.github.lukebemish.excavated_variants.ModifiedOreBlock;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import io.github.lukebemish.excavated_variants.platform.Services;
import io.github.lukebemish.excavated_variants.util.Pair;
import io.github.lukebemish.excavated_variants.worldgen.IOreFound;
import io.github.lukebemish.excavated_variants.worldgen.OreGenMapSavedData;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public class OreReplacer
extends Feature<NoneFeatureConfiguration> {
    public OreReplacer() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        return this.modifyUnmodifiedNeighboringChunks(ctx.m_159774_(), ctx.m_159777_());
    }

    public boolean modifyUnmodifiedNeighboringChunks(WorldGenLevel level, BlockPos pos) {
        OreGenMapSavedData data = OreGenMapSavedData.getOrCreate((ServerLevelAccessor)level);
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        if (data.edgeCount.containsKey(new Pair<Integer, Integer>(pos.m_123341_(), pos.m_123343_())) && data.edgeCount.get(new Pair<Integer, Integer>(pos.m_123341_(), pos.m_123343_())) == 8) {
            ChunkAccess chunkAccess = level.m_46865_(pos);
            this.modifyChunk(chunkAccess, minY, maxY);
            data.edgeCount.put(new Pair<Integer, Integer>(pos.m_123341_(), pos.m_123343_()), 9);
        }
        int[] xs = new int[]{-1, 0, 1, 1, -1, -1, 0, 1};
        int[] zs = new int[]{-1, -1, -1, 0, 0, 1, 1, 1};
        for (int i = 0; i < xs.length; ++i) {
            BlockPos newPos = new BlockPos(pos.m_123341_() + xs[i] * 16, pos.m_123342_(), pos.m_123343_() + zs[i] * 16);
            Pair<Integer, Integer> chunkPos = new Pair<Integer, Integer>(pos.m_123341_() + xs[i] * 16, pos.m_123343_() + zs[i] * 16);
            if (!data.edgeCount.containsKey(chunkPos)) {
                data.edgeCount.put(chunkPos, 0);
            }
            data.edgeCount.put(chunkPos, data.edgeCount.get(chunkPos) + 1);
            if (data.edgeCount.get(chunkPos) != 8 || !data.ranMap.containsKey(chunkPos) || !data.ranMap.get(chunkPos).booleanValue()) continue;
            ChunkAccess chunkAccess = level.m_46865_(newPos);
            this.modifyChunk(chunkAccess, minY, maxY);
            data.edgeCount.put(chunkPos, 9);
        }
        data.ranMap.put(new Pair<Integer, Integer>(pos.m_123341_(), pos.m_123343_()), true);
        return true;
    }

    public boolean modifyChunk(ChunkAccess chunkAccess, int minY, int maxY) {
        LevelChunkSection chunkSection = chunkAccess.m_183278_(chunkAccess.m_151564_(minY));
        for (int y = minY; y < maxY; ++y) {
            BlockState[][][] cache = new BlockState[16][16][16];
            int sectionIndex = chunkAccess.m_151564_(y);
            if (chunkAccess.m_151564_(chunkSection.m_63017_()) != sectionIndex) {
                chunkSection = chunkAccess.m_183278_(sectionIndex);
            }
            if (chunkSection.m_188008_()) continue;
            for (int i = 0; i < 16; ++i) {
                block2: for (int j = 0; j < 16; ++j) {
                    BlockState newState = cache[i][y & 0xF][j] == null ? chunkSection.m_62982_(i, y & 0xF, j) : cache[i][y & 0xF][j];
                    @Nullable Pair<BaseOre, HashSet<BaseStone>> pair = ((IOreFound)newState.m_60734_()).excavated_variants$get_pair();
                    if (cache[i][y & 0xF][j] == null) {
                        cache[i][y & 0xF][j] = newState;
                    }
                    if (pair == null) continue;
                    int[] as = new int[]{1, 0, 0, -1, 0, 0};
                    int[] bs = new int[]{0, -1, 1, 0, 0, 0};
                    int[] ys = new int[]{0, 0, 0, 0, -1, 1};
                    for (int c = 0; c < as.length; ++c) {
                        BaseStone stone;
                        if (i + as[c] >= 16 || i + as[c] < 0 || j + bs[c] >= 16 || j + bs[c] < 0 || y + ys[c] < chunkSection.m_63017_() || y + ys[c] >= chunkSection.m_63017_() + 16) continue;
                        BlockState thisState = cache[i + as[c]][y + ys[c] & 0xF][j + bs[c]];
                        if (thisState == null) {
                            cache[i + as[c]][y + ys[c] & 0xF][j + bs[c]] = thisState = chunkSection.m_62982_(i + as[c], y + ys[c] & 0xF, j + bs[c]);
                        }
                        if ((stone = ((IOreFound)thisState.m_60734_()).excavated_variants$get_stone()) == null) continue;
                        Block oreBlock = Services.REGISTRY_UTIL.getBlockById(new ResourceLocation("excavated_variants", stone.id + "_" + pair.first().id));
                        if (!pair.last().contains(stone) || !(oreBlock instanceof ModifiedOreBlock)) continue;
                        ModifiedOreBlock modifiedOreBlock = (ModifiedOreBlock)oreBlock;
                        BlockState def = modifiedOreBlock.getStateForReplacement(thisState);
                        chunkSection.m_62991_(i, y & 0xF, j, def, false);
                        continue block2;
                    }
                }
            }
        }
        return true;
    }
}

