/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.data.ModData;
import io.github.lukebemish.excavated_variants.platform.Services;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ModConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().excludeFieldsWithoutExposeAnnotation().create();
    public static final Path CONFIG_PATH = Services.PLATFORM.getConfigFolder();
    public static final String FULL_PATH = CONFIG_PATH + "/excavated_variants.json";
    public static final String DIR_PATH = CONFIG_PATH + "/excavated_variants/";
    public static final int CURRENT_VERSION = 6;
    @Expose
    public int format = 0;
    @Expose
    public List<String> priority = new ArrayList<String>();
    public List<ModData> mods = new ArrayList<ModData>();
    @Expose
    public List<String> blacklist_ids = new ArrayList<String>();
    @Expose
    public List<String> blacklist_stones = new ArrayList<String>();
    @Expose
    public List<String> blacklist_ores = new ArrayList<String>();
    @Expose
    public boolean attempt_ore_generation_insertion = true;
    @Expose
    public boolean attempt_ore_replacement = true;
    @Expose
    public boolean add_conversion_recipes = true;
    @Expose
    public boolean jei_rei_compat = true;
    @Expose
    public boolean unobtainable_variants = false;

    public static ModConfig getDefault() {
        ModConfig output = new ModConfig();
        output.format = 6;
        try {
            Path path;
            URL url = ModConfig.class.getResource("/default_configs/");
            if (url == null) {
                throw new IOException("default_configs resource not found!");
            }
            try {
                path = Paths.get(url.toURI());
            }
            catch (FileSystemNotFoundException e) {
                HashMap env = new HashMap();
                path = FileSystems.newFileSystem(url.toURI(), env).getPath("/default_configs/", new String[0]);
            }
            Files.list(path).forEach(p -> {
                try {
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)Files.newBufferedReader(p, StandardCharsets.UTF_8), JsonObject.class);
                    ModData data = (ModData)ModData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {
                        ExcavatedVariants.LOGGER.error("Config file is corrupted: {}", e);
                        throw new JsonSyntaxException("");
                    });
                    output.mods.add(data);
                }
                catch (IOException e2) {
                    ExcavatedVariants.LOGGER.error("Could not find default config: " + p.getFileName());
                }
                catch (JsonSyntaxException e3) {
                    ExcavatedVariants.LOGGER.error("Issue reading default config: " + p.getFileName());
                }
            });
        }
        catch (IOException | URISyntaxException e) {
            ExcavatedVariants.LOGGER.error("Could not load some default configs.", (Throwable)e);
        }
        output.priority = List.of("geolosys.json", "minecraft.json");
        return output;
    }

    private static ModConfig load() {
        ModConfig config = new ModConfig();
        try {
            ModConfig.checkExistence();
            config = (ModConfig)GSON.fromJson((Reader)new FileReader(FULL_PATH), ModConfig.class);
            if (config.format != 6) {
                ExcavatedVariants.LOGGER.error("Config is outdated! An attempt to load with this config would crash. Using default config instead...");
                return ModConfig.getDefault();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (JsonSyntaxException e3) {
            block19: {
                try {
                    JsonObject reader = (JsonObject)GSON.fromJson((Reader)new FileReader(FULL_PATH), JsonObject.class);
                    if (!reader.has("format") || !reader.get("format").isJsonPrimitive() || !reader.get("format").getAsJsonPrimitive().isNumber()) break block19;
                    JsonPrimitive p = reader.get("format").getAsJsonPrimitive();
                    try {
                        int i = p.getAsInt();
                        if (i != 6) {
                            ExcavatedVariants.LOGGER.error("Config is outdated! An attempt to load with this config would crash. Using default config instead...");
                            return ModConfig.getDefault();
                        }
                    }
                    catch (NumberFormatException i) {}
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                    ExcavatedVariants.LOGGER.error("Config existence is inconsistent! Using default config instead...");
                    return ModConfig.getDefault();
                }
            }
            ExcavatedVariants.LOGGER.error("Config is not the expected syntax! (It may be outdated). An attempt to load with this config would crash. Using default config instead...");
            return ModConfig.getDefault();
        }
        ArrayList<CallSite> loaded = new ArrayList<CallSite>();
        for (String p : config.priority) {
            try {
                JsonObject json = (JsonObject)GSON.fromJson((Reader)new FileReader(DIR_PATH + p), JsonObject.class);
                ModData data = (ModData)ModData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {
                    ExcavatedVariants.LOGGER.error("Config file is corrupted: {}", e);
                    throw new JsonSyntaxException("");
                });
                config.mods.add(data);
                loaded.add((CallSite)((Object)(p + ".json")));
            }
            catch (FileNotFoundException e4) {
                ExcavatedVariants.LOGGER.error("Could not find referenced config: " + p);
            }
            catch (JsonSyntaxException e5) {
                ExcavatedVariants.LOGGER.error("Issue reading config: " + p);
            }
        }
        try {
            for (Path s : Files.list(Path.of(DIR_PATH, new String[0])).toList()) {
                String p = s.getFileName().toString();
                if (loaded.contains(p)) continue;
                try {
                    JsonObject json = (JsonObject)GSON.fromJson((Reader)new FileReader(DIR_PATH + p), JsonObject.class);
                    ModData data = (ModData)ModData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {
                        ExcavatedVariants.LOGGER.error("Config file is corrupted: {}", e);
                        throw new JsonSyntaxException("");
                    });
                    config.mods.add(data);
                }
                catch (FileNotFoundException e6) {
                    ExcavatedVariants.LOGGER.error("Could not find config: " + p);
                }
                catch (JsonSyntaxException e7) {
                    ExcavatedVariants.LOGGER.error("Issue reading config: " + p);
                }
            }
        }
        catch (IOException e8) {
            ExcavatedVariants.LOGGER.error("Could not load config directory...", (Throwable)e8);
        }
        return config;
    }

    public static ModConfig get() {
        ModConfig config = ModConfig.load();
        if (config.format != 6) {
            ExcavatedVariants.LOGGER.error("Config is outdated! An attempt to load with this config would crash. Using default config instead...");
            return ModConfig.getDefault();
        }
        return config;
    }

    public static void save(ModConfig config) {
        try {
            ModConfig.checkExistence();
            FileWriter writer = new FileWriter(FULL_PATH);
            GSON.toJson((Object)config, (Appendable)writer);
            writer.flush();
            writer.close();
            for (ModData m : config.mods) {
                JsonElement json = (JsonElement)ModData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)m).getOrThrow(false, e -> ExcavatedVariants.LOGGER.error("Default config file is corrupted during write. Something is very wrong: {}", e));
                if (json == null) continue;
                FileWriter w = new FileWriter(DIR_PATH + String.join((CharSequence)"_", m.mod_id) + ".json");
                GSON.toJson(json, (Appendable)w);
                w.flush();
                w.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static void checkExistence() throws IOException {
        Path path;
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
        }
        if (!Files.exists(CONFIG_PATH.resolve("excavated_variants"), new LinkOption[0])) {
            Files.createDirectories(CONFIG_PATH.resolve("excavated_variants"), new FileAttribute[0]);
        }
        if (!Files.exists(path = Path.of(FULL_PATH, new String[0]), new LinkOption[0])) {
            Files.createFile(path, new FileAttribute[0]);
            ModConfig.save(ModConfig.getDefault());
        }
    }
}

