/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;

public class StructureBlockReplacementHandler {
    public static List<StructureFunction> functions = new ArrayList<StructureFunction>();
    private static final ThreadLocal<StructureHolder> structureHolder = new ThreadLocal();

    public static BlockState getResultingBlockState(ServerLevelAccessor level, BlockState blockstate) {
        StructureHolder curr = StructureBlockReplacementHandler.getCurrentStructureHolder();
        if (curr != null && curr.currentStructure != null) {
            for (StructureFunction fun : functions) {
                BlockState res = fun.transformBlockstate(level, blockstate, curr);
                if (res == null) continue;
                return res;
            }
        }
        return blockstate;
    }

    private static StructureHolder getCurrentStructureHolder() {
        return structureHolder.get();
    }

    public static void setActiveStructure(ConfiguredStructureFeature<?, ?> structure, PiecesContainer components) {
        StructureHolder curr = StructureBlockReplacementHandler.getCurrentStructureHolder();
        if (curr == null) {
            curr = new StructureHolder();
            structureHolder.set(curr);
        }
        curr.currentStructure = structure;
        curr.currentComponents = components == null ? null : components.f_192741_();
    }

    public static class StructureHolder {
        public ConfiguredStructureFeature<?, ?> currentStructure;
        public List<StructurePiece> currentComponents;
    }

    @FunctionalInterface
    public static interface StructureFunction {
        public BlockState transformBlockstate(ServerLevelAccessor var1, BlockState var2, StructureHolder var3);
    }
}

