/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.Pair;

public class RayTraceHandler {
    public static HitResult rayTrace(Entity entity, Level world, Player player, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return RayTraceHandler.rayTrace(entity, world, (Entity)player, blockMode, fluidMode, RayTraceHandler.getEntityRange((LivingEntity)player));
    }

    public static HitResult rayTrace(Entity entity, Level world, Entity player, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, double range) {
        Pair<Vec3, Vec3> params = RayTraceHandler.getEntityParams(player);
        return RayTraceHandler.rayTrace(entity, world, (Vec3)params.getLeft(), (Vec3)params.getRight(), blockMode, fluidMode, range);
    }

    public static HitResult rayTrace(Entity entity, Level world, Vec3 startPos, Vec3 ray, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, double range) {
        return RayTraceHandler.rayTrace(entity, world, startPos, ray.m_82490_(range), blockMode, fluidMode);
    }

    public static HitResult rayTrace(Entity entity, Level world, Vec3 startPos, Vec3 ray, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        Vec3 end = startPos.m_82549_(ray);
        ClipContext context = new ClipContext(startPos, end, blockMode, fluidMode, entity);
        return world.m_45547_(context);
    }

    public static double getEntityRange(LivingEntity player) {
        return player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
    }

    public static Pair<Vec3, Vec3> getEntityParams(Entity player) {
        float scale = 1.0f;
        float pitch = player.f_19860_ + (player.m_146909_() - player.f_19860_) * scale;
        float yaw = player.f_19859_ + (player.m_146908_() - player.f_19859_) * scale;
        Vec3 pos = player.m_20182_();
        double posX = player.f_19854_ + (pos.f_82479_ - player.f_19854_) * (double)scale;
        double posY = player.f_19855_ + (pos.f_82480_ - player.f_19855_) * (double)scale;
        if (player instanceof Player) {
            posY += (double)player.m_20192_();
        }
        double posZ = player.f_19856_ + (pos.f_82481_ - player.f_19856_) * (double)scale;
        Vec3 rayPos = new Vec3(posX, posY, posZ);
        float zYaw = -Mth.m_14089_((float)(yaw * (float)Math.PI / 180.0f));
        float xYaw = Mth.m_14031_((float)(yaw * (float)Math.PI / 180.0f));
        float pitchMod = -Mth.m_14089_((float)(pitch * (float)Math.PI / 180.0f));
        float azimuth = -Mth.m_14031_((float)(pitch * (float)Math.PI / 180.0f));
        float xLen = xYaw * pitchMod;
        float yLen = zYaw * pitchMod;
        Vec3 ray = new Vec3((double)xLen, (double)azimuth, (double)yLen);
        return Pair.of((Object)rayPos, (Object)ray);
    }
}

