/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import vazkii.quark.base.client.config.screen.AbstractQScreen;
import vazkii.quark.base.client.config.screen.widgets.ScrollableWidgetList;

public abstract class AbstractScrollingWidgetScreen
extends AbstractQScreen {
    private final List<AbstractWidget> scrollingWidgets = new LinkedList<AbstractWidget>();
    private ScrollableWidgetList<?, ?> elementList;
    private Button resetButton;
    private boolean needsScrollUpdate = false;
    private double currentScroll = 0.0;

    public AbstractScrollingWidgetScreen(Screen parent) {
        super(parent);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.elementList = this.createWidgetList();
        this.m_7787_((GuiEventListener)this.elementList);
        this.refresh();
        this.needsScrollUpdate = true;
        int pad = 3;
        int bWidth = 121;
        int left = (this.f_96543_ - (bWidth + pad) * 3) / 2;
        int vStart = this.f_96544_ - 30;
        this.m_142416_((GuiEventListener)new Button(left, vStart, bWidth, 20, (Component)new TranslatableComponent("quark.gui.config.default"), this::onClickDefault));
        this.resetButton = new Button(left + bWidth + pad, vStart, bWidth, 20, (Component)new TranslatableComponent("quark.gui.config.discard"), this::onClickDiscard);
        this.m_142416_((GuiEventListener)this.resetButton);
        this.m_142416_((GuiEventListener)new Button(left + (bWidth + pad) * 2, vStart, bWidth, 20, (Component)new TranslatableComponent("gui.done"), this::onClickDone));
    }

    public void m_96624_() {
        super.m_96624_();
        this.resetButton.f_93623_ = this.isDirty();
    }

    public void refresh() {
        this.scrollingWidgets.clear();
        this.elementList.populate(w -> {
            this.scrollingWidgets.add((AbstractWidget)w);
            if (w instanceof Button) {
                this.m_142416_((GuiEventListener)w);
            } else {
                this.m_7787_((GuiEventListener)w);
            }
        });
    }

    @Override
    public void m_6305_(@Nonnull PoseStack mstack, int mouseX, int mouseY, float partialTicks) {
        if (this.needsScrollUpdate) {
            this.elementList.m_93410_(this.currentScroll);
            this.needsScrollUpdate = false;
        }
        this.currentScroll = this.elementList.m_93517_();
        this.scrollingWidgets.forEach(w -> {
            w.f_93624_ = false;
        });
        this.m_7333_(mstack);
        this.elementList.m_6305_(mstack, mouseX, mouseY, partialTicks);
        LinkedList visibleWidgets = new LinkedList();
        this.scrollingWidgets.forEach(w -> {
            if (w.f_93624_) {
                visibleWidgets.add(w);
            }
            w.f_93624_ = false;
        });
        super.m_6305_(mstack, mouseX, mouseY, partialTicks);
        Window main = this.f_96541_.m_91268_();
        int res = (int)main.m_85449_();
        RenderSystem.m_69488_((int)0, (int)(40 * res), (int)(this.f_96543_ * res), (int)((this.f_96544_ - 80) * res));
        visibleWidgets.forEach(w -> {
            w.f_93624_ = true;
            w.m_6305_(mstack, mouseX, mouseY, partialTicks);
        });
        RenderSystem.m_69471_();
    }

    public boolean m_6375_(double x, double y, int button) {
        return super.m_6375_(x, y, button);
    }

    protected abstract ScrollableWidgetList<?, ?> createWidgetList();

    protected abstract void onClickDefault(Button var1);

    protected abstract void onClickDiscard(Button var1);

    protected abstract boolean isDirty();

    protected void onClickDone(Button b) {
        this.returnToParent(b);
    }
}

