/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.tags;

import io.github.lukebemish.dynamic_asset_generator.Pair;
import io.github.lukebemish.dynamic_asset_generator.api.ResettingSupplier;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class TagBuilder {
    private final List<Pair<ResourceLocation, Supplier<Boolean>>> paths = new ArrayList<Pair<ResourceLocation, Supplier<Boolean>>>();

    public void add(Pair<ResourceLocation, Supplier<Boolean>> p) {
        this.paths.add(p);
    }

    public ResettingSupplier<InputStream> supply() {
        return new ResettingSupplier<InputStream>(){

            @Override
            public void reset() {
                for (Pair<ResourceLocation, Supplier<Boolean>> p : TagBuilder.this.paths) {
                    Supplier<Boolean> supplier = p.last();
                    if (!(supplier instanceof ResettingSupplier)) continue;
                    ResettingSupplier rs = (ResettingSupplier)supplier;
                    rs.reset();
                }
            }

            @Override
            public InputStream get() {
                return TagBuilder.this.build();
            }
        };
    }

    private InputStream build() {
        StringBuilder internal = new StringBuilder();
        for (Pair<ResourceLocation, Supplier<Boolean>> p : this.paths) {
            if (!p.last().get().booleanValue()) continue;
            ResourceLocation rl = p.first();
            if (internal.length() >= 1) {
                internal.append(",");
            }
            internal.append("\"").append(rl.m_135827_()).append(":").append(rl.m_135815_()).append("\"");
        }
        String json = "{\"replace\":false,\"values\":[" + internal + "]}";
        return new ByteArrayInputStream(json.getBytes());
    }
}

