/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.forge;

import com.google.gson.JsonObject;
import io.github.lukebemish.dynamic_asset_generator.DynAssetGenServerPlanner;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.jetbrains.annotations.Nullable;

public class DynAssetGenServerDataPack
implements PackResources {
    private Map<ResourceLocation, Supplier<InputStream>> streams;
    private static final int PACK_VERSION = 8;

    private Map<ResourceLocation, Supplier<InputStream>> getStreams() {
        if (this.streams == null) {
            this.streams = DynAssetGenServerPlanner.getResources();
        }
        return this.streams;
    }

    @Nullable
    public InputStream m_5542_(String location) throws IOException {
        if (!location.contains("/") && !location.contains("\\")) {
            Supplier<InputStream> supplier = this.getStreams().get(location);
            return supplier.get();
        }
        throw new IllegalArgumentException("File name can't be a path");
    }

    public InputStream m_8031_(PackType packType, ResourceLocation location) throws IOException {
        if (packType == PackType.SERVER_DATA && this.getStreams().containsKey(location)) {
            InputStream stream = this.getStreams().get(location).get();
            if (stream != null) {
                return stream;
            }
            throw new IOException("Data is null: " + location.toString());
        }
        throw new IOException("Could not find resource in generated data: " + location.toString());
    }

    public Collection<ResourceLocation> m_7466_(PackType packType, String namespace, String directory, int depth, Predicate<String> predicate) {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        if (packType == PackType.SERVER_DATA) {
            for (ResourceLocation key : this.getStreams().keySet()) {
                if (!key.toString().startsWith(directory) || !key.m_135827_().equals(namespace) || !predicate.test(key.m_135815_()) || this.getStreams().get(key).get() == null) continue;
                locations.add(key);
            }
        }
        return locations;
    }

    public boolean m_7211_(PackType packType, ResourceLocation location) {
        if (packType == PackType.SERVER_DATA && this.getStreams().containsKey(location)) {
            return this.getStreams().get(location).get() != null;
        }
        return false;
    }

    public Set<String> m_5698_(PackType packType) {
        HashSet<String> namespaces = new HashSet<String>();
        if (packType == PackType.SERVER_DATA) {
            for (ResourceLocation key : this.getStreams().keySet()) {
                namespaces.add(key.m_135827_());
            }
        }
        return namespaces;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) throws IOException {
        if (serializer.m_7991_().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)8);
            object.addProperty("description", "dynamically generated assets");
            return (T)serializer.m_6322_(object);
        }
        DynamicAssetGenerator.LOGGER.info("'" + serializer.m_7991_() + "' is an unsupported metadata key!");
        return (T)serializer.m_6322_(new JsonObject());
    }

    public String m_8017_() {
        return "dynamic_asset_generator:data";
    }

    public void close() {
    }
}

