/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.github.lukebemish.dynamic_asset_generator.datagen.ImageSource;
import io.github.lukebemish.dynamic_asset_generator.datagen.TextureConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;

public abstract class TextureConfigProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final String modid;
    private final Map<ResourceLocation, TextureConfig> generatedConfigs = new HashMap<ResourceLocation, TextureConfig>();

    public TextureConfigProvider(DataGenerator generator, String modid) {
        this.generator = generator;
        this.modid = modid;
    }

    public abstract void addConfigs();

    public final TextureConfig config(String path) {
        return this.generatedConfigs.computeIfAbsent(new ResourceLocation(this.modid, path), loc -> new TextureConfig());
    }

    public final ImageSource.File fileSource(ResourceLocation texture) {
        return new ImageSource.File(this, texture);
    }

    public final ImageSource.Fallback fallbackSource() {
        return new ImageSource.Fallback(this);
    }

    public final ImageSource.Color colorSource() {
        return new ImageSource.Color(this);
    }

    public final ImageSource.Overlay overlaySource() {
        return new ImageSource.Overlay(this);
    }

    public final ImageSource.Mask maskSource() {
        return new ImageSource.Mask(this);
    }

    public final ImageSource.Crop cropSource() {
        return new ImageSource.Crop(this);
    }

    public final ImageSource.Transform transformSource() {
        return new ImageSource.Transform(this);
    }

    public final ImageSource.CombinedPalettedImage combinedPalettedImageSource() {
        return new ImageSource.CombinedPalettedImage(this);
    }

    public final ImageSource.ForegroundTransfer foregroundTransferSource() {
        return new ImageSource.ForegroundTransfer(this);
    }

    protected boolean checkTextureExists(ResourceLocation texture) {
        return true;
    }

    public final void m_6865_(HashCache cache) {
        this.generatedConfigs.clear();
        this.addConfigs();
        this.writeConfigs(cache);
    }

    private void writeConfigs(HashCache cache) {
        for (ResourceLocation location : this.generatedConfigs.keySet()) {
            Path target = this.generator.m_123916_().resolve(String.format("assets/%s/dynamic_assets_sources/%s.json", location.m_135827_(), location.m_135815_()));
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)this.generatedConfigs.get(location).toJson(), (Path)target);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String m_6055_() {
        return "Texture Configs";
    }
}

