/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.datagen;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lukebemish.dynamic_asset_generator.datagen.ImageSource;
import net.minecraft.resources.ResourceLocation;

public final class TextureConfig {
    private ImageSource input;
    private ResourceLocation output;

    public TextureConfig input(ImageSource input) {
        this.input = input;
        return this;
    }

    public TextureConfig output(ResourceLocation output) {
        Preconditions.checkNotNull((Object)output, (Object)"Output texture must not be null");
        this.output = output;
        return this;
    }

    JsonObject toJson() {
        Preconditions.checkNotNull((Object)this.input, (Object)"No input set");
        Preconditions.checkNotNull((Object)this.output, (Object)"No output set");
        JsonObject object = new JsonObject();
        object.addProperty("output_location", this.output.toString());
        object.add("input", (JsonElement)this.input.toJson());
        return object;
    }
}

