/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.client.util.SafeImageExtraction;
import java.util.function.Supplier;

public class Transform
implements ITexSource {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public Supplier<NativeImage> getSupplier(String inputStr) throws JsonSyntaxException {
        LocationSource locationSource = (LocationSource)gson.fromJson(inputStr, LocationSource.class);
        Supplier<NativeImage> input = DynamicTextureJson.readSupplierFromSource(locationSource.input);
        return () -> {
            if (input == null) {
                DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...");
                return null;
            }
            NativeImage inImg = (NativeImage)input.get();
            if (inImg == null) {
                DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...\n{}", (Object)locationSource.input.toString());
                return null;
            }
            NativeImage output = inImg;
            for (int i = 0; i < locationSource.rotate; ++i) {
                output = Transform.clockwiseRotate(output);
            }
            if (locationSource.flip) {
                NativeImage output2 = NativeImageHelper.of(output.m_85102_(), output.m_84982_(), output.m_85084_(), false);
                for (int x = 0; x < output.m_84982_(); ++x) {
                    for (int y = 0; y < output.m_85084_(); ++y) {
                        output2.m_84988_(output.m_84982_() - 1 - x, y, SafeImageExtraction.get(output, x, y));
                    }
                }
                output.close();
                output = output2;
            }
            return output;
        };
    }

    private static NativeImage clockwiseRotate(NativeImage input) {
        int w = input.m_84982_();
        int h = input.m_85084_();
        NativeImage output = NativeImageHelper.of(input.m_85102_(), h, w, false);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                output.m_84988_(y, w - x - 1, SafeImageExtraction.get(input, x, y));
            }
        }
        input.close();
        return output;
    }

    public static class LocationSource {
        @Expose
        String source_type;
        @Expose
        int rotate;
        @Expose
        boolean flip;
        @Expose
        public JsonObject input;
    }
}

